/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.internal.CollectionInfoRetriever;
import com.mongodb.async.client.internal.CommandMarker;
import com.mongodb.async.client.internal.Crypt;
import com.mongodb.async.client.internal.KeyManagementService;
import com.mongodb.async.client.internal.KeyRetriever;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoCrypts;
import com.mongodb.internal.capi.MongoCryptOptionsHelper;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptOptionsHelper.createMongoCryptOptions((Map)options.getKmsProviders(), (Map)options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createKeyManagementService(), options.isBypassAutoEncryption());
    }

    public static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptOptionsHelper.createMongoCryptOptions((Map)options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(MongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        MongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = MongoClients.create(keyVaultMongoClientSettings);
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", (Throwable)e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

