/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NameableObject;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.RefreshTokenManager;
import org.mule.security.oauth.callback.DefaultHttpCallbackAdapter;
import org.mule.security.oauth.process.ManagedAccessTokenProcessTemplate;
import org.mule.security.oauth.util.DefaultOAuthResponseParser;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.security.oauth.util.HttpUtilImpl;
import org.mule.security.oauth.util.OAuthResponseParser;
import org.slf4j.Logger;

public abstract class BaseOAuth2Manager<C extends OAuth2Adapter>
extends DefaultHttpCallbackAdapter
implements MuleContextAware,
Initialisable,
Capabilities,
Startable,
Stoppable,
Disposable,
OAuth2Manager<OAuth2Adapter>,
NameableObject {
    private OAuth2Adapter defaultUnauthorizedConnector = this.instantiateAdapter();
    private String applicationName;
    private String scope;
    private RefreshTokenManager refreshTokenManager;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private ObjectStore<Serializable> accessTokenObjectStore;
    private KeyedPoolableObjectFactory<String, OAuth2Adapter> accessTokenPoolFactory;
    private GenericKeyedObjectPool<String, OAuth2Adapter> accessTokenPool;
    private HttpUtil httpUtil;
    private OAuthResponseParser oauthResponseParser;
    private String defaultAccessTokenId;

    protected abstract Logger getLogger();

    protected abstract OAuth2Adapter instantiateAdapter();

    protected abstract KeyedPoolableObjectFactory<String, OAuth2Adapter> createPoolFactory(OAuth2Manager<OAuth2Adapter> var1, ObjectStore<Serializable> var2);

    protected abstract void setCustomProperties(OAuth2Adapter var1);

    protected abstract void fetchCallbackParameters(OAuth2Adapter var1, String var2);

    @Override
    public final void initialise() throws InitialisationException {
        super.initialise();
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.testOnBorrow = true;
        if (this.accessTokenObjectStore == null) {
            this.accessTokenObjectStore = (ObjectStore)this.muleContext.getRegistry().lookupObject("_defaultUserObjectStore");
            if (this.accessTokenObjectStore == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"There is no default user object store on this Mule instance."), (Initialisable)this);
            }
        }
        this.accessTokenPoolFactory = this.createPoolFactory(this, this.accessTokenObjectStore);
        this.accessTokenPool = new GenericKeyedObjectPool(this.accessTokenPoolFactory, config);
        if (this.defaultUnauthorizedConnector instanceof Initialisable) {
            ((Initialisable)this.defaultUnauthorizedConnector).initialise();
        }
        if (this.httpUtil == null) {
            this.httpUtil = new HttpUtilImpl();
        }
        if (this.oauthResponseParser == null) {
            this.oauthResponseParser = new DefaultOAuthResponseParser();
        }
        if (this.refreshTokenManager == null) {
            try {
                this.refreshTokenManager = (RefreshTokenManager)this.muleContext.getRegistry().lookupObject(RefreshTokenManager.class);
            }
            catch (RegistrationException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public final void start() throws MuleException {
        if (this.defaultUnauthorizedConnector instanceof Startable) {
            ((Startable)this.defaultUnauthorizedConnector).start();
        }
    }

    public final void stop() throws MuleException {
        if (this.defaultUnauthorizedConnector instanceof Stoppable) {
            ((Stoppable)this.defaultUnauthorizedConnector).stop();
        }
    }

    public final void dispose() {
        if (this.defaultUnauthorizedConnector instanceof Disposable) {
            ((Disposable)this.defaultUnauthorizedConnector).dispose();
        }
        try {
            this.accessTokenPool.close();
        }
        catch (Exception e) {
            this.getLogger().warn("Exception found while trying to close access token pool", (Throwable)e);
        }
    }

    @Override
    public final OAuth2Adapter createAdapter(String verifier) throws Exception {
        OAuth2Adapter connector = this.instantiateAdapter();
        connector.setOauthVerifier(verifier);
        connector.setAuthorizationUrl(this.getDefaultUnauthorizedConnector().getAuthorizationUrl());
        connector.setAccessTokenUrl(this.getDefaultUnauthorizedConnector().getAccessTokenUrl());
        connector.setConsumerKey(this.getDefaultUnauthorizedConnector().getConsumerKey());
        connector.setConsumerSecret(this.getDefaultUnauthorizedConnector().getConsumerSecret());
        this.setCustomProperties(connector);
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.muleContext);
        }
        if (connector instanceof Initialisable) {
            ((Initialisable)connector).initialise();
        }
        if (connector instanceof Startable) {
            ((Startable)connector).start();
        }
        return connector;
    }

    @Override
    public final OAuth2Adapter acquireAccessToken(String accessTokenId) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics before acquiring [key %s] [active=%d] [idle=%d]", accessTokenId, this.accessTokenPool.getNumActive((Object)accessTokenId), this.accessTokenPool.getNumIdle((Object)accessTokenId)));
        }
        OAuth2Adapter object = (OAuth2Adapter)this.accessTokenPool.borrowObject((Object)accessTokenId);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics after acquiring [key %s] [active=%d] [idle=%d]", accessTokenId, this.accessTokenPool.getNumActive((Object)accessTokenId), this.accessTokenPool.getNumIdle((Object)accessTokenId)));
        }
        return object;
    }

    @Override
    public final void releaseAccessToken(String userId, OAuth2Adapter connector) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics before releasing [key %s] [active=%d] [idle=%d]", userId, this.accessTokenPool.getNumActive((Object)userId), this.accessTokenPool.getNumIdle((Object)userId)));
        }
        this.accessTokenPool.returnObject((Object)userId, (Object)connector);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics after releasing [key %s] [active=%d] [idle=%d]", userId, this.accessTokenPool.getNumActive((Object)userId), this.accessTokenPool.getNumIdle((Object)userId)));
        }
    }

    @Override
    public final void destroyAccessToken(String userId, OAuth2Adapter connector) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics before destroying [key %s] [active=%d] [idle=%d]", userId, this.accessTokenPool.getNumActive((Object)userId), this.accessTokenPool.getNumIdle((Object)userId)));
        }
        this.accessTokenPool.invalidateObject((Object)userId, (Object)connector);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Pool Statistics after destroying [key %s] [active=%d] [idle=%d]", userId, this.accessTokenPool.getNumActive((Object)userId), this.accessTokenPool.getNumIdle((Object)userId)));
        }
    }

    @Override
    public final String buildAuthorizeUrl(Map<String, String> extraParameters, String authorizationUrl, String redirectUri) {
        StringBuilder urlBuilder = new StringBuilder();
        if (authorizationUrl != null) {
            urlBuilder.append(authorizationUrl);
        } else {
            urlBuilder.append(this.getDefaultUnauthorizedConnector().getAuthorizationUrl());
        }
        urlBuilder.append("?").append("response_type=code&").append("client_id=").append(this.getDefaultUnauthorizedConnector().getConsumerKey());
        try {
            if (!StringUtils.isBlank((String)this.getScope())) {
                urlBuilder.append("&scope=").append(URLEncoder.encode(this.getScope(), "UTF-8"));
            }
            for (Map.Entry<String, String> entry : extraParameters.entrySet()) {
                urlBuilder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            urlBuilder.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Authorization URL has been generated as follows: " + urlBuilder);
        }
        return urlBuilder.toString();
    }

    @Override
    public final void fetchAccessToken(OAuth2Adapter adapter, String redirectUri) throws UnableToAcquireAccessTokenException {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("code=");
            builder.append(URLEncoder.encode(adapter.getOauthVerifier(), "UTF-8"));
            builder.append("&client_id=");
            builder.append(URLEncoder.encode(adapter.getConsumerKey(), "UTF-8"));
            builder.append("&client_secret=");
            builder.append(URLEncoder.encode(adapter.getConsumerSecret(), "UTF-8"));
            builder.append("&grant_type=");
            builder.append(URLEncoder.encode("authorization_code", "UTF-8"));
            builder.append("&redirect_uri=");
            builder.append(URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.fetchAndExtract(adapter, builder.toString(), null);
    }

    @Override
    public final void hasBeenAuthorized(OAuth2Adapter adapter) throws NotAuthorizedException {
        if (adapter.getAccessToken() == null) {
            throw new NotAuthorizedException("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        }
    }

    @Override
    public final void refreshAccessToken(OAuth2Adapter adapter, String accessTokenId) throws UnableToAcquireAccessTokenException {
        if (adapter.getRefreshToken() == null) {
            throw new IllegalStateException("Cannot refresh access token since refresh token is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to refresh access token...");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("grant_type=refresh_token");
        builder.append("&client_id=");
        builder.append(adapter.getConsumerKey());
        builder.append("&client_secret=");
        builder.append(adapter.getConsumerSecret());
        builder.append("&refresh_token=");
        builder.append(adapter.getRefreshToken());
        adapter.setAccessToken(null);
        this.fetchAndExtract(adapter, builder.toString(), accessTokenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAuthorizationEvent(MuleEvent event) throws Exception {
        DefaultMuleMessage dmm;
        MuleMessage message = event.getMessage();
        if (message instanceof DefaultMuleMessage && (dmm = (DefaultMuleMessage)message).isConsumable()) {
            try {
                message.setPayload(message.getPayload(String.class));
            }
            catch (Exception e) {
                throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("event can't be persisted because payload of class %s couldn't be consumed into a string", message.getPayload().getClass().getCanonicalName())), event, (Throwable)e);
            }
        }
        if (!(message.getPayload() instanceof Serializable)) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("In order to perform the OAuth authorization dance the mule event needs to be stored in the object store. However, the message has a payload of class %s which is not serializable.", message.getPayload().getClass().getCanonicalName())), event);
        }
        String key = this.buildAuthorizationEventKey(event.getId());
        MuleEvent muleEvent = event;
        synchronized (muleEvent) {
            try {
                if (this.accessTokenObjectStore.contains((Serializable)((Object)key))) {
                    this.accessTokenObjectStore.remove((Serializable)((Object)key));
                }
                this.accessTokenObjectStore.store((Serializable)((Object)key), (Serializable)event);
            }
            catch (ObjectStoreException e) {
                throw new MessagingException(MessageFactory.createStaticMessage((String)"Exception was thrown when trying to store the message into object store. Please check that all message properties are serializable"), event, (Throwable)e);
            }
        }
    }

    @Override
    public MuleEvent restoreAuthorizationEvent(String eventId) throws ObjectStoreException, ObjectDoesNotExistException {
        Serializable maybeEvent = this.accessTokenObjectStore.retrieve((Serializable)((Object)this.buildAuthorizationEventKey(eventId)));
        if (maybeEvent instanceof MuleEvent) {
            MuleEvent event = (MuleEvent)maybeEvent;
            if (event instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)event).resetAccessControl();
            }
            return event;
        }
        throw new IllegalArgumentException(String.format("Tried to retrieve authorization event of id %s but instead found object of class %s", eventId, maybeEvent.getClass().getCanonicalName()));
    }

    private String buildAuthorizationEventKey(String eventId) {
        return String.format("%s-authorization-event", eventId);
    }

    private void fetchAndExtract(OAuth2Adapter adapter, String requestBody, String accessTokenId) throws UnableToAcquireAccessTokenException {
        String refreshToken;
        Date expiration;
        if (adapter.getAccessToken() != null) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Retrieving access token...");
        }
        String accessTokenUrl = adapter.getAccessTokenUrl() != null ? adapter.getAccessTokenUrl() : this.getDefaultUnauthorizedConnector().getAccessTokenUrl();
        String response = this.httpUtil.post(accessTokenUrl, requestBody);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Received response [%s]", response));
        }
        adapter.setAccessToken(this.oauthResponseParser.extractAccessCode(adapter.getAccessCodePattern(), response));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Access token retrieved successfully [accessToken = %s]", adapter.getAccessToken()));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Attempting to extract expiration time using [expirationPattern = %s]", adapter.getExpirationTimePattern().pattern()));
        }
        if ((expiration = this.oauthResponseParser.extractExpirationTime(adapter.getExpirationTimePattern(), response)) != null) {
            adapter.setExpiration(expiration);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Token expiration extracted successfully [expiration = %s]", expiration));
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Token expiration could not be extracted from [response = %s]", response));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Attempting to extract refresh token time using [refreshTokenPattern = \"refresh_token\":\"([^&]+?)\"]");
        }
        if ((refreshToken = this.oauthResponseParser.extractRefreshToken(adapter.getRefreshTokenPattern(), response)) != null) {
            adapter.setRefreshToken(refreshToken);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Refresh token extracted successfully [refresh token = %s]", refreshToken));
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Refresh token could not be extracted from [response = %s]", response));
        }
        this.fetchCallbackParameters(adapter, response);
        try {
            this.postAuth(adapter, accessTokenId);
        }
        catch (Exception e) {
            throw new UnableToAcquireAccessTokenException("Adapter was successfuly retrieved but an exception was found after invoking the postAuth() method", (Throwable)e);
        }
    }

    @Override
    public void postAuth(OAuth2Adapter adapter, String accessTokenId) throws Exception {
        block7: {
            try {
                adapter.postAuth();
            }
            catch (Exception e) {
                boolean tokenRefreshed = false;
                if (accessTokenId != null) {
                    for (Class<Exception> clazz : this.refreshAccessTokenOn()) {
                        if (!clazz.isAssignableFrom(e.getClass())) continue;
                        Logger logger = this.getLogger();
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Tried to execute postAuth() postAuth in adapter of class %s with accessTokenId %s but token was expired. Attempting refresh", adapter.getClass().getCanonicalName(), accessTokenId));
                        }
                        try {
                            this.refreshTokenManager.refreshToken(adapter, accessTokenId);
                            adapter.postAuth();
                            tokenRefreshed = true;
                        }
                        catch (Exception re) {
                            logger.error(String.format("Could not refresh access token %s on adapter of class %s while attempting postAuth(). Will throw the original exception", accessTokenId, adapter.getClass().getCanonicalName()));
                            throw e;
                        }
                    }
                }
                if (tokenRefreshed) break block7;
                throw e;
            }
        }
    }

    protected Set<Class<? extends Exception>> refreshAccessTokenOn() {
        return Collections.emptySet();
    }

    @Override
    public final boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == ModuleCapability.OAUTH2_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.OAUTH_ACCESS_TOKEN_MANAGEMENT_CAPABLE;
    }

    @Override
    public <T> ProcessTemplate<T, OAuth2Adapter> getProcessTemplate() {
        return new ManagedAccessTokenProcessTemplate(this, this.muleContext);
    }

    @Override
    public OAuth2Adapter getDefaultUnauthorizedConnector() {
        return this.defaultUnauthorizedConnector;
    }

    public void setApplicationName(String value) {
        this.applicationName = value;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setScope(String value) {
        this.scope = value;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public final MuleContext getMuleContext() {
        return this.muleContext;
    }

    public final void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        if (this.defaultUnauthorizedConnector instanceof MuleContextAware) {
            ((MuleContextAware)this.defaultUnauthorizedConnector).setMuleContext(muleContext);
        }
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (this.defaultUnauthorizedConnector instanceof FlowConstructAware) {
            ((FlowConstructAware)this.defaultUnauthorizedConnector).setFlowConstruct(flowConstruct);
        }
    }

    public ObjectStore<Serializable> getAccessTokenObjectStore() {
        return this.accessTokenObjectStore;
    }

    public void setAccessTokenObjectStore(ObjectStore<Serializable> value) {
        this.accessTokenObjectStore = value;
    }

    @Override
    public KeyedPoolableObjectFactory<String, OAuth2Adapter> getAccessTokenPoolFactory() {
        return this.accessTokenPoolFactory;
    }

    public void setHttpUtil(HttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }

    public void setOauthResponseParser(OAuthResponseParser oauthResponseParser) {
        this.oauthResponseParser = oauthResponseParser;
    }

    public void setAuthorizationUrl(String value) {
        this.defaultUnauthorizedConnector.setAuthorizationUrl(value);
    }

    public void setAccessTokenUrl(String value) {
        this.defaultUnauthorizedConnector.setAccessTokenUrl(value);
    }

    public void setConsumerKey(String value) {
        this.defaultUnauthorizedConnector.setConsumerKey(value);
    }

    public void setConsumerSecret(String value) {
        this.defaultUnauthorizedConnector.setConsumerSecret(value);
    }

    protected void setDefaultUnauthorizedConnector(OAuth2Adapter defaultUnauthorizedConnector) {
        this.defaultUnauthorizedConnector = defaultUnauthorizedConnector;
    }

    public String getConsumerKey() {
        return this.defaultUnauthorizedConnector.getConsumerKey();
    }

    public String getConsumerSecret() {
        return this.defaultUnauthorizedConnector.getConsumerSecret();
    }

    public String getName() {
        return this.defaultUnauthorizedConnector.getName();
    }

    public void setName(String name) {
        this.defaultUnauthorizedConnector.setName(name);
    }

    @Override
    public OnNoTokenPolicy getOnNoTokenPolicy() {
        return this.defaultUnauthorizedConnector.getOnNoTokenPolicy();
    }

    @Override
    public void setOnNoTokenPolicy(OnNoTokenPolicy policy) {
        this.defaultUnauthorizedConnector.setOnNoTokenPolicy(policy);
    }

    @Override
    public String getDefaultAccessTokenId() {
        return this.defaultAccessTokenId;
    }

    public void setDefaultAccessTokenId(String defaultAccessTokenId) {
        this.defaultAccessTokenId = defaultAccessTokenId;
    }

    public void setRefreshTokenManager(RefreshTokenManager refreshTokenManager) {
        this.refreshTokenManager = refreshTokenManager;
    }

    protected void setAccessTokenPool(GenericKeyedObjectPool<String, OAuth2Adapter> accessTokenPool) {
        this.accessTokenPool = accessTokenPool;
    }
}

