/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.annotations.param.UseConfig;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.introspection.MuleExtensionAnnotationParser;
import org.mule.module.extension.internal.runtime.ArgumentResolverDelegate;
import org.mule.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.ConfigurationInstanceArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.EventArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.MessageArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;

final class MethodArgumentResolverDelegate
implements ArgumentResolverDelegate {
    private final Method method;
    private ArgumentResolver<? extends Object>[] argumentResolvers;

    public MethodArgumentResolverDelegate(Method method) {
        this.method = method;
        this.initArgumentResolvers();
    }

    private void initArgumentResolvers() {
        Object[] parameterTypes = this.method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            this.argumentResolvers = new ArgumentResolver[0];
            return;
        }
        this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        String[] paramNames = MuleExtensionAnnotationParser.getParamNames(this.method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
            ArgumentResolver<Object> argumentResolver = annotations.containsKey(UseConfig.class) ? ConfigurationInstanceArgumentResolver.getInstance() : (MuleEvent.class.isAssignableFrom((Class<?>)parameterType) ? EventArgumentResolver.getInstance() : (MuleMessage.class.isAssignableFrom((Class<?>)parameterType) ? MessageArgumentResolver.getInstance() : (annotations.containsKey(ParameterGroup.class) ? new ParameterGroupArgumentResolver(parameterType) : new ByParameterNameArgumentResolver(paramNames[i]))));
            this.argumentResolvers[i] = argumentResolver;
        }
    }

    @Override
    public Object[] resolve(OperationContext operationContext) {
        Object[] parameterValues = new Object[this.argumentResolvers.length];
        int i = 0;
        for (ArgumentResolver<? extends Object> argumentResolver : this.argumentResolvers) {
            parameterValues[i++] = argumentResolver.resolve(operationContext);
        }
        return parameterValues;
    }
}

