/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLMetadataLookupHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLMetadataLookupHandler.class);
    @NonnullAfterInit
    private RoleDescriptorResolver metadataResolver;
    @Nonnull
    private Class<? extends AbstractSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;
    @Nullable
    private Function<MessageContext, SAMLMetadataContext> copyContextStrategy;

    public void setCopyContextStrategy(@Nullable Function<MessageContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.copyContextStrategy = strategy;
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractSAMLEntityContext> clazz) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.entityContextClass = (Class)Constraint.isNotNull(clazz, (String)"SAML entity context class may not be null");
    }

    public void setRoleDescriptorResolver(@Nonnull RoleDescriptorResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = (RoleDescriptorResolver)Constraint.isNotNull((Object)resolver, (String)"RoleDescriptorResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        AbstractSAMLEntityContext entityCtx = (AbstractSAMLEntityContext)messageContext.getSubcontext(this.entityContextClass);
        if (entityCtx == null || entityCtx.getEntityId() == null || entityCtx.getRole() == null) {
            this.log.info("{} SAML entity context class '{}' missing or did not contain an entityID or role", (Object)this.getLogPrefix(), (Object)this.entityContextClass.getName());
            return;
        }
        SAMLMetadataContext existingMetadataCtx = this.resolveExisting(messageContext, entityCtx.getEntityId(), entityCtx.getRole());
        if (existingMetadataCtx != null) {
            this.log.info("{} Resolved existing metadata context, re-using it", (Object)this.getLogPrefix());
            entityCtx.addSubcontext((BaseContext)existingMetadataCtx);
            return;
        }
        EntityIdCriterion entityIdCriterion = new EntityIdCriterion(entityCtx.getEntityId());
        EntityRoleCriterion roleCriterion = new EntityRoleCriterion(entityCtx.getRole());
        ProtocolCriterion protocolCriterion = null;
        SAMLProtocolContext protocolCtx = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class);
        if (protocolCtx != null && protocolCtx.getProtocol() != null) {
            protocolCriterion = new ProtocolCriterion(protocolCtx.getProtocol());
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{entityIdCriterion, protocolCriterion, roleCriterion});
        try {
            RoleDescriptor roleMetadata = (RoleDescriptor)this.metadataResolver.resolveSingle((Object)criteria);
            if (roleMetadata == null) {
                if (protocolCriterion != null) {
                    this.log.info("{} No metadata returned for {} in role {} with protocol {}", new Object[]{this.getLogPrefix(), entityCtx.getEntityId(), entityCtx.getRole(), protocolCriterion.getProtocol()});
                } else {
                    this.log.info("{} No metadata returned for {} in role {}", new Object[]{this.getLogPrefix(), entityCtx.getEntityId(), entityCtx.getRole()});
                }
                return;
            }
            SAMLMetadataContext metadataCtx = new SAMLMetadataContext();
            metadataCtx.setEntityDescriptor((EntityDescriptor)roleMetadata.getParent());
            metadataCtx.setRoleDescriptor(roleMetadata);
            entityCtx.addSubcontext((BaseContext)metadataCtx);
            this.log.debug("{} {} added to MessageContext as child of {}", new Object[]{this.getLogPrefix(), SAMLMetadataContext.class.getName(), this.entityContextClass.getName()});
        }
        catch (ResolverException e) {
            this.log.error("{} ResolverException thrown during metadata lookup", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    @Nullable
    protected SAMLMetadataContext resolveExisting(@Nonnull MessageContext messageContext, @Nonnull String entityID, @Nonnull QName role) {
        if (this.copyContextStrategy == null) {
            return null;
        }
        SAMLMetadataContext existing = this.copyContextStrategy.apply(messageContext);
        if (existing != null) {
            if (existing.getEntityDescriptor() != null && existing.getRoleDescriptor() != null) {
                if (Objects.equals(existing.getEntityDescriptor().getEntityID(), entityID) && (Objects.equals(existing.getRoleDescriptor().getElementQName(), role) || Objects.equals(existing.getRoleDescriptor().getSchemaType(), role))) {
                    this.log.debug("{} Found an existing and suitable SAMLMetadataContext from which to copy ", (Object)this.getLogPrefix());
                    SAMLMetadataContext copy = new SAMLMetadataContext();
                    copy.setEntityDescriptor(existing.getEntityDescriptor());
                    copy.setRoleDescriptor(existing.getRoleDescriptor());
                    return copy;
                }
                this.log.debug("{} Existing SAMLMetadataContext was resolved, but was either the entityID or role did not match the entity context data", (Object)this.getLogPrefix());
            }
            this.log.debug("{} Existing SAMLMetadataContext was resolved, but was missing EntityDescriptor or RoleDescriptor data", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} No existing SAMLMetadataContext was resolved", (Object)this.getLogPrefix());
        }
        return null;
    }
}

