/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.type;

import java.util.HashMap;
import org.organicdesign.fp.FunctionUtils;
import org.organicdesign.fp.StaticImports;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.type.ArrayHolder;

public final class RuntimeTypes {
    private static final HashMap<ArrayHolder<Class>, ImList<Class>> typeMap = new HashMap();

    @Deprecated
    private RuntimeTypes() {
        throw new UnsupportedOperationException("No instantiation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImList<Class> registerClasses(Class ... cs) {
        ImList<Class> registeredTypes;
        if (cs == null) {
            throw new IllegalArgumentException("Can't register a null type array");
        }
        if (cs.length == 0) {
            throw new IllegalArgumentException("Can't register a zero-length type array");
        }
        for (Class c : cs) {
            if (c != null) continue;
            throw new IllegalArgumentException("There shouldn't be any null types in this array!");
        }
        ArrayHolder<Class> ah = new ArrayHolder<Class>(cs);
        Lock lock = Lock.INSTANCE;
        synchronized (lock) {
            registeredTypes = typeMap.get(ah);
            if (registeredTypes == null) {
                ImList<Class> vecCs = StaticImports.vec(cs);
                typeMap.put(ah, vecCs);
                registeredTypes = vecCs;
            }
        }
        return registeredTypes;
    }

    public static String name(Class c) {
        return c == null ? "null" : c.getSimpleName();
    }

    public static String union2Str(Object item, ImList<Class> types) {
        StringBuilder sB = new StringBuilder();
        sB.append(FunctionUtils.stringify(item)).append(":");
        boolean isFirst = true;
        for (Class c : types) {
            if (isFirst) {
                isFirst = false;
            } else {
                sB.append("|");
            }
            sB.append(RuntimeTypes.name(c));
        }
        return sB.toString();
    }

    static int size() {
        return typeMap.size();
    }

    private static enum Lock {
        INSTANCE;

    }
}

