/**
 * 
 */
package javax.transaction;

import java.rmi.RemoteException;
 
/**
 * This exception indicates that the transaction associated with
 * processing of the request has been rolled back, or it has been
 * marked to roll back. Thus the requested operation either could
 * not be performed or was not performed because further computation
 * on behalf of the transaction would be fruitless.
 * @author Guillaume Sauthier
 */
public class TransactionRolledbackException extends RemoteException {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = -3142798139623020577L;

    /**
     * Creates a new TransactionRolledbackException.
     */
    public TransactionRolledbackException() {
        super();
    }

    /**
     * Creates a new TransactionRolledbackException.
     * @param msg Exception message
     */
    public TransactionRolledbackException(String msg) {
        super(msg);
    }
}
