/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.ow2.spec.testengine.AnalyzerAnnotationVisitor;
import org.ow2.spec.testengine.metadata.AnnotationMetadata;
import org.ow2.spec.testengine.metadata.ClassMetadata;
import org.ow2.spec.testengine.metadata.FieldMetadata;
import org.ow2.spec.testengine.metadata.InnerClassMetadata;
import org.ow2.spec.testengine.metadata.MethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerClassVisitor
implements ClassVisitor {
    private Map<String, Map<String, ClassMetadata>> packageClassesMetadataMap = null;
    private ClassMetadata classMetaData = null;

    public AnalyzerClassVisitor(Map<String, Map<String, ClassMetadata>> packageClassesMetadataMap) {
        this.packageClassesMetadataMap = packageClassesMetadataMap;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classMetaData = new ClassMetadata(access, name, signature, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationMetadata annotationMetadata = new AnnotationMetadata(desc, visible);
        this.classMetaData.addAnnotationMetadata(annotationMetadata);
        return new AnalyzerAnnotationVisitor(annotationMetadata);
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 2) == 0) {
            InnerClassMetadata innerClassMetadata = new InnerClassMetadata(name, outerName, innerName, access);
            this.classMetaData.addInnerClassMetadata(innerClassMetadata);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 2) == 0) {
            FieldMetadata fieldMetadata = new FieldMetadata(access, name, desc, signature, value);
            this.classMetaData.addFieldMetadata(fieldMetadata);
        }
        return new EmptyVisitor();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 2) == 0) {
            MethodMetadata methodMetadata = new MethodMetadata(access, name, desc, signature, exceptions);
            this.classMetaData.addMethodMetadata(methodMetadata);
        }
        return new EmptyVisitor();
    }

    public void visitEnd() {
        String packageName = "";
        String[] split = this.classMetaData.getName().split("/");
        packageName = packageName + split[0];
        packageName = packageName + ".";
        Map<String, ClassMetadata> classMetadataMap = this.packageClassesMetadataMap.get(packageName = packageName + split[1]);
        if (classMetadataMap == null) {
            classMetadataMap = new HashMap<String, ClassMetadata>();
            this.packageClassesMetadataMap.put(packageName, classMetadataMap);
        }
        classMetadataMap.put(this.classMetaData.getName(), this.classMetaData);
    }

    public void setUID(long uid) {
        this.classMetaData.setUID(uid);
    }
}

