/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.metadata;

import java.util.ArrayList;
import java.util.List;
import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AbsMetadata;
import org.ow2.spec.testengine.metadata.EnumAnnotationMetadata;

public class AnnotationMetadata
extends AbsMetadata {
    private String desc = null;
    private boolean visible = false;
    private List<EnumAnnotationMetadata> enumAnnotationMetadataList = null;

    public AnnotationMetadata(String desc, boolean visible) {
        this.desc = desc;
        this.visible = visible;
        this.enumAnnotationMetadataList = new ArrayList<EnumAnnotationMetadata>();
    }

    public void addEnumAnnotationMetadata(EnumAnnotationMetadata enumAnnotationMetadata) {
        this.enumAnnotationMetadataList.add(enumAnnotationMetadata);
    }

    public String getName() {
        return this.desc;
    }

    public void compare(AnnotationMetadata other, SignatureResultSet rs) {
        this.compare(this.getName() + " desc", this.desc, other.desc, rs);
        this.compare(this.getName() + " visible", this.visible, other.visible, rs);
        AnnotationMetadata.compareList(this.getName() + " enum", this.enumAnnotationMetadataList, other.enumAnnotationMetadataList, rs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationMetadata)) {
            return false;
        }
        SignatureResultSet rs = new SignatureResultSet();
        try {
            this.compare((AnnotationMetadata)o, rs);
        }
        catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }

    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        String newIndent = indent + "  ";
        sb.append("\n");
        sb.append(indent);
        sb.append("<annotation");
        this.addObjectToSB("desc", this.desc, sb);
        this.addObjectToSB("visible", this.visible, sb);
        if (this.enumAnnotationMetadataList.size() > 0) {
            sb.append(">");
            AnnotationMetadata.addListToSB(this.enumAnnotationMetadataList, sb, newIndent);
            sb.append("\n");
            sb.append(indent);
            sb.append("</annotation>");
        } else {
            sb.append(" />");
        }
        return sb.toString();
    }
}

