/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.metadata;

import java.util.ArrayList;
import java.util.List;
import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AbsMetadata;
import org.ow2.spec.testengine.metadata.AnnotationMetadata;
import org.ow2.spec.testengine.metadata.FieldMetadata;
import org.ow2.spec.testengine.metadata.InnerClassMetadata;
import org.ow2.spec.testengine.metadata.MethodMetadata;

public class ClassMetadata
extends AbsMetadata {
    private long uid = 0L;
    private int access;
    private String name;
    private String signature;
    private String superName;
    private String[] interfaces;
    private List<MethodMetadata> methodMetadataList = null;
    private List<FieldMetadata> fieldMetadataList = null;
    private List<AnnotationMetadata> annotationMetadataList = null;
    private List<InnerClassMetadata> innerClassMetadataList = null;

    public ClassMetadata(int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = interfaces;
        if (interfaces != null && interfaces.length == 0) {
            this.interfaces = null;
        }
        this.methodMetadataList = new ArrayList<MethodMetadata>();
        this.fieldMetadataList = new ArrayList<FieldMetadata>();
        this.annotationMetadataList = new ArrayList<AnnotationMetadata>();
        this.innerClassMetadataList = new ArrayList<InnerClassMetadata>();
    }

    public void addMethodMetadata(MethodMetadata methodMetadata) {
        this.methodMetadataList.add(methodMetadata);
    }

    public void addFieldMetadata(FieldMetadata fieldMetadata) {
        this.fieldMetadataList.add(fieldMetadata);
    }

    public void addAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        this.annotationMetadataList.add(annotationMetadata);
    }

    public void addInnerClassMetadata(InnerClassMetadata innerClassMetadata) {
        this.innerClassMetadataList.add(innerClassMetadata);
    }

    public void setUID(long uid) {
        this.uid = uid;
    }

    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        String newIndent = indent + "  ";
        sb.append(indent);
        sb.append("<class");
        this.addObjectToSB("name", this.name, sb);
        this.addObjectToSB("super-name", this.superName, sb);
        this.addObjectToSB("access", this.access, sb);
        this.addObjectToSB("signature", this.signature, sb);
        if (this.uid != 0L) {
            this.addObjectToSB("uid", this.uid, sb);
        }
        sb.append(" >");
        this.addArrayObjectToSB("interface", this.interfaces, sb, newIndent);
        ClassMetadata.addListToSB(this.innerClassMetadataList, sb, newIndent);
        ClassMetadata.addListToSB(this.annotationMetadataList, sb, newIndent);
        ClassMetadata.addListToSB(this.methodMetadataList, sb, newIndent);
        ClassMetadata.addListToSB(this.fieldMetadataList, sb, newIndent);
        sb.append("\n");
        sb.append(indent);
        sb.append("</class>\n");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void compare(ClassMetadata other, SignatureResultSet rs) {
        this.compare(this.getName() + " access", this.access, other.access, rs);
        this.compare(this.getName() + " name", this.name, other.name, rs);
        this.compare(this.getName() + " super class name", this.superName, other.superName, rs);
        this.compare(this.getName() + " signature", this.signature, other.signature, rs);
        this.compare(this.getName() + " interfaces", this.interfaces, other.interfaces, rs);
        this.compare(this.getName() + " uid", this.uid, other.uid, rs);
        ClassMetadata.compareList(this.getName() + " inner class", this.innerClassMetadataList, other.innerClassMetadataList, rs);
        ClassMetadata.compareList(this.getName() + " methods", this.methodMetadataList, other.methodMetadataList, rs);
        ClassMetadata.compareList(this.getName() + " methods", this.fieldMetadataList, other.fieldMetadataList, rs);
        ClassMetadata.compareList(this.getName() + " annotations", this.annotationMetadataList, other.annotationMetadataList, rs);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassMetadata)) {
            return false;
        }
        SignatureResultSet rs = new SignatureResultSet();
        try {
            this.compare((ClassMetadata)o, rs);
        }
        catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }
}

