/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AbsMetadata;

public class FieldMetadata
extends AbsMetadata {
    private int access = 0;
    private String name = null;
    private String desc = null;
    private String signature = null;
    private Object value = null;

    public FieldMetadata(int access, String name, String desc, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void compare(FieldMetadata other, SignatureResultSet rs) {
        this.compare(this.getName() + " access", this.access, other.access, rs);
        this.compare(this.getName() + " name", this.name, other.name, rs);
        this.compare(this.getName() + " desc", this.desc, other.desc, rs);
        this.compare(this.getName() + " signature", this.signature, other.signature, rs);
        this.compare(this.getName() + " value", this.value, other.value, rs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldMetadata)) {
            return false;
        }
        SignatureResultSet rs = new SignatureResultSet();
        try {
            this.compare((FieldMetadata)o, rs);
        }
        catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }

    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(indent);
        sb.append("<field");
        this.addObjectToSB("name", this.name, sb);
        this.addObjectToSB("desc", this.desc, sb);
        this.addObjectToSB("signature", this.signature, sb);
        this.addObjectToSB("access", this.access, sb);
        this.addObjectToSB("value", this.value, sb);
        sb.append(" />");
        return sb.toString();
    }
}

