/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtils {
    private XMLUtils() {
    }

    public static String getAttributeValue(Element base, String name) {
        NamedNodeMap mapAttributes = base.getAttributes();
        Node node = mapAttributes.getNamedItem(name);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getStringValueElement(String ns, Element base, String name) {
        String value = null;
        NodeList list = base.getElementsByTagNameNS(ns, name);
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            Node node = element.getFirstChild();
            if (node != null) {
                value = node.getNodeValue();
            }
        } else if (list.getLength() > 1) {
            throw new IllegalStateException("Element '" + name + "' on '" + base + "' should be unique but there are '" + list.getLength() + "' elements");
        }
        return value;
    }

    public static String getChildStringValueForElement(Element base, String name) {
        String value = null;
        NodeList nodeList = base.getChildNodes();
        if (nodeList.getLength() > 0) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node elNode;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !name.equals(node.getNodeName()) || (elNode = ((Element)node).getFirstChild()) == null) continue;
                value = elNode.getNodeValue();
                break;
            }
        }
        return value;
    }

    public static Properties getPropertiesValueElement(String ns, Element base, String name) {
        Properties returnedProperties = new Properties();
        NodeList list = base.getElementsByTagNameNS(ns, name);
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            NodeList properties = element.getElementsByTagNameNS(ns, "property");
            if (properties.getLength() > 0) {
                for (int i = 0; i < properties.getLength(); ++i) {
                    Element elemProperty = (Element)properties.item(i);
                    String pName = XMLUtils.getAttributeValue(elemProperty, "name");
                    String pValue = XMLUtils.getAttributeValue(elemProperty, "value");
                    if (pName == null || pValue == null) continue;
                    returnedProperties.setProperty(pName, pValue);
                }
            }
        } else if (list.getLength() > 1) {
            throw new IllegalStateException("Element '" + name + "' on '" + base + "' should be unique but there are '" + list.getLength() + "' elements");
        }
        return returnedProperties;
    }

    public static List<String> getStringListValueElement(String ns, Element base, String name) {
        ArrayList<String> returnedlist = new ArrayList<String>();
        NodeList list = base.getElementsByTagNameNS(ns, name);
        int length = list.getLength();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Element element = (Element)list.item(i);
                Node node = element.getFirstChild();
                if (node == null) continue;
                returnedlist.add(node.getNodeValue());
            }
        }
        return returnedlist;
    }
}

