/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.fileio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.owasp.fileio.Encoder;
import org.owasp.fileio.StringValidationRule;
import org.owasp.fileio.ValidationException;
import org.owasp.fileio.util.Utils;

public class FileValidator {
    public static final String FILE_NAME_REGEX = "^[a-zA-Z0-9!@#$%^&{}\\[\\]()_+\\-=,.~'` ]{1,255}$";
    public static final String DIRECTORY_NAME_REGEX = "^[a-zA-Z0-9:/\\\\!@#$%^&{}\\[\\]()_+\\-=,.~'` ]{1,255}$";
    private Encoder fileEncoder;
    private Long maxFileUploadSize = 500000000L;
    private Integer maxFilePathSize = 255;
    List<String> allowedExtensions = new ArrayList<String>();

    public FileValidator() {
        this.fileEncoder = new Encoder();
    }

    public FileValidator(Encoder encoder) {
        this.fileEncoder = encoder;
    }

    public Long getMaxFileUploadSize() {
        return this.maxFileUploadSize;
    }

    public void setMaxFileUploadSize(Long maxFileUploadSize) {
        this.maxFileUploadSize = maxFileUploadSize;
    }

    public List<String> getAllowedExtensions() {
        return this.allowedExtensions;
    }

    public void setAllowedExtensions(List<String> allowedExtensions) {
        this.allowedExtensions = allowedExtensions;
    }

    public Integer getMaxFilePathSize() {
        return this.maxFilePathSize;
    }

    public void setMaxFilePathSize(Integer maxFilePathSize) {
        this.maxFilePathSize = maxFilePathSize;
    }

    public Encoder getFileEncoder() {
        return this.fileEncoder;
    }

    public void setFileEncoder(Encoder fileEncoder) {
        this.fileEncoder = fileEncoder;
    }

    public boolean isValidDirectoryPath(String context, String input, File parent, boolean allowNull) {
        try {
            this.getValidDirectoryPath(context, input, parent, allowNull);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public boolean isValidDirectoryPath(String context, String input, File parent, boolean allowNull, List<ValidationException> errors) {
        try {
            this.getValidDirectoryPath(context, input, parent, allowNull);
            return true;
        }
        catch (ValidationException e) {
            errors.add(e);
            return false;
        }
    }

    public String getValidDirectoryPath(String context, String input, File parent, boolean allowNull) throws ValidationException {
        try {
            if (Utils.isEmpty(input)) {
                if (allowNull) {
                    return null;
                }
                throw new ValidationException(context + ": Input directory path required", "Input directory path required: context=" + context + ", input=" + input, context);
            }
            File dir = new File(input);
            if (!dir.exists()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, does not exist: context=" + context + ", input=" + input);
            }
            if (!dir.isDirectory()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, not a directory: context=" + context + ", input=" + input);
            }
            if (!parent.exists()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, specified parent does not exist: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            if (!parent.isDirectory()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, specified parent is not a directory: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            if (!dir.getCanonicalPath().startsWith(parent.getCanonicalPath())) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, not inside specified parent: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            String canonicalPath = dir.getCanonicalPath();
            String canonical = this.getValidInput(context, canonicalPath, DIRECTORY_NAME_REGEX, this.maxFilePathSize, false);
            if (!canonical.equals(input)) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory name does not match the canonical path: context=" + context + ", input=" + input + ", canonical=" + canonical, context);
            }
            return canonical;
        }
        catch (Exception e) {
            throw new ValidationException(context + ": Invalid directory name", "Failure to validate directory path: context=" + context + ", input=" + input, e, context);
        }
    }

    public String getValidDirectoryPath(String context, String input, File parent, boolean allowNull, List<ValidationException> errors) {
        try {
            return this.getValidDirectoryPath(context, input, parent, allowNull);
        }
        catch (ValidationException e) {
            errors.add(e);
            return "";
        }
    }

    public boolean isValidFileName(String context, String input, boolean allowNull) {
        return this.isValidFileName(context, input, null, allowNull);
    }

    public boolean isValidFileName(String context, String input, boolean allowNull, List<ValidationException> errors) {
        return this.isValidFileName(context, input, null, allowNull, errors);
    }

    public boolean isValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull) {
        try {
            this.getValidFileName(context, input, allowedExtensions, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull, List<ValidationException> errors) {
        try {
            this.getValidFileName(context, input, allowedExtensions, allowNull);
            return true;
        }
        catch (ValidationException e) {
            errors.add(e);
            return false;
        }
    }

    public String getValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull) throws ValidationException {
        String canonical = "";
        try {
            if (Utils.isEmpty(input)) {
                if (allowNull) {
                    return null;
                }
                throw new ValidationException(context + ": Input file name required", "Input required: context=" + context + ", input=" + input, context);
            }
            canonical = new File(input).getCanonicalFile().getName();
            this.getValidInput(context, input, FILE_NAME_REGEX, 255, true);
            File f = new File(canonical);
            String c = f.getCanonicalPath();
            String cpath = c.substring(c.lastIndexOf(File.separator) + 1);
            if (!input.equals(cpath)) {
                throw new ValidationException(context + ": Invalid file name", "Invalid directory name does not match the canonical path: context=" + context + ", input=" + input + ", canonical=" + canonical, context);
            }
        }
        catch (IOException e) {
            throw new ValidationException(context + ": Invalid file name", "Invalid file name does not exist: context=" + context + ", canonical=" + canonical, e, context);
        }
        if (allowedExtensions == null || allowedExtensions.isEmpty()) {
            return canonical;
        }
        for (String ext : allowedExtensions) {
            if (!input.toLowerCase().endsWith(ext.toLowerCase())) continue;
            return canonical;
        }
        throw new ValidationException(context + ": Invalid file name does not have valid extension ( " + allowedExtensions + ")", "Invalid file name does not have valid extension ( " + allowedExtensions + "): context=" + context + ", input=" + input, context);
    }

    public String getValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull, List<ValidationException> errors) {
        try {
            return this.getValidFileName(context, input, allowedExtensions, allowNull);
        }
        catch (ValidationException e) {
            errors.add(e);
            return "";
        }
    }

    public boolean isValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, boolean allowNull) throws ValidationException {
        return this.isValidFileName(context, filename, allowNull) && this.isValidDirectoryPath(context, directorypath, parent, allowNull) && this.isValidFileContent(context, content, maxBytes, allowNull);
    }

    public boolean isValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, boolean allowNull, List<ValidationException> errors) {
        return this.isValidFileName(context, filename, allowNull, errors) && this.isValidDirectoryPath(context, directorypath, parent, allowNull, errors) && this.isValidFileContent(context, content, maxBytes, allowNull, errors);
    }

    public void assertValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, List<String> allowedExtensions, boolean allowNull) throws ValidationException {
        this.getValidFileName(context, filename, allowedExtensions, allowNull);
        this.getValidDirectoryPath(context, directorypath, parent, allowNull);
        this.getValidFileContent(context, content, maxBytes, allowNull);
    }

    public void assertValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, List<String> allowedExtensions, boolean allowNull, List<ValidationException> errors) {
        try {
            this.assertValidFileUpload(context, directorypath, filename, parent, content, maxBytes, allowedExtensions, allowNull);
        }
        catch (ValidationException e) {
            errors.add(e);
        }
    }

    public boolean isValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull) {
        try {
            this.getValidFileContent(context, input, maxBytes, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull, List<ValidationException> errors) {
        try {
            this.getValidFileContent(context, input, maxBytes, allowNull);
            return true;
        }
        catch (ValidationException e) {
            errors.add(e);
            return false;
        }
    }

    public byte[] getValidFileContent(String context, byte[] input, boolean allowNull) throws ValidationException {
        return this.getValidFileContent(context, input, this.getMaxFileUploadSize(), allowNull);
    }

    public byte[] getValidFileContent(String context, byte[] input, long maxBytes, boolean allowNull) throws ValidationException {
        if (Utils.isEmpty(input)) {
            if (allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input required", "Input required: context=" + context + ", input=" + Arrays.toString(input), context);
        }
        if ((long)input.length > maxBytes) {
            throw new ValidationException(context + ": Invalid file content can not exceed " + maxBytes + " bytes", "Exceeded maxBytes ( " + input.length + ")", context);
        }
        return input;
    }

    public byte[] getValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull, List<ValidationException> errors) throws ValidationException {
        try {
            return this.getValidFileContent(context, input, maxBytes, allowNull);
        }
        catch (ValidationException e) {
            errors.add(e);
            return new byte[0];
        }
    }

    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull) throws ValidationException {
        return this.getValidInput(context, input, type, maxLength, allowNull, true);
    }

    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull, boolean canonicalize) throws ValidationException {
        StringValidationRule rvr = new StringValidationRule(type, this.fileEncoder);
        Pattern p = Pattern.compile(type);
        rvr.addWhitelistPattern(p);
        rvr.setMaximumLength(maxLength);
        rvr.setAllowNull(allowNull);
        rvr.setValidateInputAndCanonical(canonicalize);
        return rvr.getValid(context, input);
    }
}

