/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.fileio;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.owasp.fileio.Encoder;
import org.owasp.fileio.ValidationException;
import org.owasp.fileio.util.NullSafe;
import org.owasp.fileio.util.Utils;

public class StringValidationRule {
    protected String typeName;
    protected Encoder encoder;
    protected boolean allowNull = false;
    protected List<Pattern> whitelistPatterns = new ArrayList<Pattern>();
    protected List<Pattern> blacklistPatterns = new ArrayList<Pattern>();
    protected int minLength = 0;
    protected int maxLength = Integer.MAX_VALUE;
    protected boolean validateInputAndCanonical = true;

    public StringValidationRule(String typeName) {
        this.typeName = typeName;
    }

    public StringValidationRule(String typeName, Encoder encoder) {
        this.typeName = typeName;
        this.encoder = encoder;
    }

    public StringValidationRule(String typeName, Encoder encoder, String whitelistPattern) {
        this.typeName = typeName;
        this.encoder = encoder;
        this.addWhitelistPattern(whitelistPattern);
    }

    public void addWhitelistPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        try {
            this.whitelistPatterns.add(Pattern.compile(pattern));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Validation misconfiguration, problem with specified pattern: " + pattern, e);
        }
    }

    public void addWhitelistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.whitelistPatterns.add(p);
    }

    public void addBlacklistPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        try {
            this.blacklistPatterns.add(Pattern.compile(pattern));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Validation misconfiguration, problem with specified pattern: " + pattern, e);
        }
    }

    public void addBlacklistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.blacklistPatterns.add(p);
    }

    public void setMinimumLength(int length) {
        this.minLength = length;
    }

    public void setMaximumLength(int length) {
        this.maxLength = length;
    }

    public void setValidateInputAndCanonical(boolean flag) {
        this.validateInputAndCanonical = flag;
    }

    private String checkWhitelist(String context, String input, String orig) throws ValidationException {
        for (Pattern p : this.whitelistPatterns) {
            if (p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Please conform to regex " + p.pattern() + (this.maxLength == Integer.MAX_VALUE ? "" : " with a maximum length of " + this.maxLength), "Invalid input: context=" + context + ", type(" + this.getTypeName() + ")=" + p.pattern() + ", input=" + input + (NullSafe.equals(orig, input) ? "" : ", orig=" + orig), context);
        }
        return input;
    }

    private String checkWhitelist(String context, String input) throws ValidationException {
        return this.checkWhitelist(context, input, input);
    }

    private String checkBlacklist(String context, String input, String orig) throws ValidationException {
        for (Pattern p : this.blacklistPatterns) {
            if (!p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Dangerous input matching " + p.pattern() + " detected.", "Dangerous input: context=" + context + ", type(" + this.getTypeName() + ")=" + p.pattern() + ", input=" + input + (NullSafe.equals(orig, input) ? "" : ", orig=" + orig), context);
        }
        return input;
    }

    private String checkBlacklist(String context, String input) throws ValidationException {
        return this.checkBlacklist(context, input, input);
    }

    private String checkLength(String context, String input, String orig) throws ValidationException {
        if (input.length() < this.minLength) {
            throw new ValidationException(context + ": Invalid input. The minimum length of " + this.minLength + " characters was not met.", "Input does not meet the minimum length of " + this.minLength + " by " + (this.minLength - input.length()) + " characters: context=" + context + ", type=" + this.getTypeName() + "), input=" + input + (NullSafe.equals(input, orig) ? "" : ", orig=" + orig), context);
        }
        if (input.length() > this.maxLength) {
            throw new ValidationException(context + ": Invalid input. The maximum length of " + this.maxLength + " characters was exceeded.", "Input exceeds maximum allowed length of " + this.maxLength + " by " + (input.length() - this.maxLength) + " characters: context=" + context + ", type=" + this.getTypeName() + ", orig=" + orig + ", input=" + input, context);
        }
        return input;
    }

    private String checkLength(String context, String input) throws ValidationException {
        return this.checkLength(context, input, input);
    }

    private String checkEmpty(String context, String input, String orig) throws ValidationException {
        if (!Utils.isEmpty(input)) {
            return input;
        }
        if (this.allowNull) {
            return null;
        }
        throw new ValidationException(context + ": Input required.", "Input required: context=" + context + "), input=" + input + (NullSafe.equals(input, orig) ? "" : ", orig=" + orig), context);
    }

    private String checkEmpty(String context, String input) throws ValidationException {
        return this.checkEmpty(context, input, input);
    }

    public String getValid(String context, String input) throws ValidationException {
        String data = null;
        if (this.checkEmpty(context, input) == null) {
            return null;
        }
        if (this.validateInputAndCanonical) {
            this.checkLength(context, input);
            this.checkWhitelist(context, input);
            this.checkBlacklist(context, input);
            data = this.encoder.canonicalize(input);
        } else {
            data = input;
        }
        if (this.checkEmpty(context, data, input) == null) {
            return null;
        }
        this.checkLength(context, data, input);
        this.checkWhitelist(context, data, input);
        this.checkBlacklist(context, data, input);
        return data;
    }

    public String sanitize(String context, String input) {
        return this.whitelist(input, Encoder.CHAR_ALPHANUMERICS);
    }

    public String whitelist(String input, char[] whitelist) {
        Set<Character> whiteSet = Utils.arrayToSet(whitelist);
        return this.whitelist(input, whiteSet);
    }

    public String whitelist(String input, Set<Character> whitelist) {
        StringBuilder stripped = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!whitelist.contains(Character.valueOf(c))) continue;
            stripped.append(c);
        }
        return stripped.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }
}

