/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.BaseNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.Position;

public abstract class JBaseRamlNode
extends BaseNode {
    private JsonNode jsonNode;
    private String resourcePath;
    private final ResourceLoader resourceLoader;

    public JBaseRamlNode(JsonNode jsonNode, String resourcePath, ResourceLoader resourceLoader) {
        this.jsonNode = jsonNode;
        this.resourcePath = resourcePath;
        this.resourceLoader = resourceLoader;
    }

    protected JBaseRamlNode(JBaseRamlNode node) {
        super(node);
        this.jsonNode = node.getJsonNode();
        this.resourcePath = node.getResourcePath();
        this.resourceLoader = node.getResourceLoader();
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Nullable
    public String getLiteralValue() {
        if (this.jsonNode instanceof NumericNode) {
            return this.getJsonNode().textValue();
        }
        return this.getJsonNode().textValue();
    }

    @Override
    @Nonnull
    public Position getStartPosition() {
        return DefaultPosition.emptyPosition();
    }

    @Override
    @Nonnull
    public Position getEndPosition() {
        return DefaultPosition.emptyPosition();
    }
}

