/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class OkHttpClient
implements HttpClient {
    private final okhttp3.OkHttpClient client;
    private final URL baseUrl;

    public OkHttpClient(okhttp3.OkHttpClient client, URL url) {
        this.client = client;
        this.baseUrl = url;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        return this.execute(request, true);
    }

    @Override
    public HttpResponse execute(HttpRequest request, boolean followRedirects) throws IOException {
        HttpUrl.Builder url;
        if (followRedirects != this.client.followRedirects()) {
            throw new IllegalArgumentException("Unable to change how the http client follows redirets");
        }
        Request.Builder builder = new Request.Builder();
        try {
            String rawUrl = this.baseUrl.toExternalForm().replaceAll("/$", "") + request.getUri();
            url = HttpUrl.parse((String)rawUrl).newBuilder();
        }
        catch (NullPointerException e) {
            throw new IOException("Unable to parse URL: " + this.baseUrl.toString() + request.getUri());
        }
        for (String name2 : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name2)) {
                url.addQueryParameter(name2, value);
            }
        }
        builder.url(url.build());
        for (String name2 : request.getHeaderNames()) {
            for (String value : request.getHeaders(name2)) {
                builder.addHeader(name2, value);
            }
        }
        switch (request.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                String rawType = Optional.of(request.getHeader("Content-Type")).orElse("application/json; charset=utf-8");
                MediaType type = MediaType.parse((String)rawType);
                RequestBody body = RequestBody.create((MediaType)type, (byte[])request.getContent());
                builder.post(body);
                break;
            }
            case DELETE: {
                builder.delete();
            }
        }
        Response response = this.client.newCall(builder.build()).execute();
        HttpResponse toReturn = new HttpResponse();
        toReturn.setContent(response.body().bytes());
        toReturn.setStatus(response.code());
        response.headers().names().forEach(name -> response.headers(name).forEach(value -> toReturn.addHeader((String)name, (String)value)));
        return toReturn;
    }

    @Override
    public void close() {
    }

    public static class Factory
    implements HttpClient.Factory {
        private ConnectionPool pool = new ConnectionPool();

        @Override
        public HttpClient createClient(URL url) {
            okhttp3.OkHttpClient client = new OkHttpClient.Builder().connectionPool(this.pool).followRedirects(true).followSslRedirects(true).build();
            return new OkHttpClient(client, url);
        }

        @Override
        public void cleanupIdleClients() {
            this.pool.evictAll();
        }
    }
}

