/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELAwareParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.QueryMapper;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DBObjectPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappedConstructor;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    protected static final Log log = LogFactory.getLog(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final MongoDbFactory mongoDbFactory;
    protected final QueryMapper idMapper;
    protected ApplicationContext applicationContext;
    protected boolean useFieldAccessOnly = true;
    protected MongoTypeMapper typeMapper;
    protected String mapKeyDotReplacement = null;

    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(ConversionServiceFactory.createDefaultConversionService());
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull(mappingContext);
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
    }

    public void setTypeMapper(MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    public void setMapKeyDotReplacement(String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setUseFieldAccessOnly(boolean useFieldAccessOnly) {
        this.useFieldAccessOnly = useFieldAccessOnly;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read(ClassTypeInformation.from(clazz), dbo);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        if (null == dbo) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(dbo, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(dbo.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)dbo;
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            return (S)this.readCollectionOrArray(typeToUse, (BasicDBList)dbo);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, dbo);
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo);
    }

    private <S> S read(MongoPersistentEntity<S> entity, final DBObject dbo) {
        final StandardEvaluationContext spelCtx = new StandardEvaluationContext((Object)dbo);
        spelCtx.addPropertyAccessor((PropertyAccessor)DBObjectPropertyAccessor.INSTANCE);
        if (this.applicationContext != null) {
            spelCtx.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        }
        final MappedConstructor constructor = new MappedConstructor(entity, this.mappingContext);
        SpELAwareParameterValueProvider delegate = new SpELAwareParameterValueProvider(this.spelExpressionParser, (EvaluationContext)spelCtx);
        DelegatingParameterValueProvider provider = new DelegatingParameterValueProvider(constructor, dbo, delegate);
        final BeanWrapper wrapper = BeanWrapper.create(entity, (ParameterValueProvider)provider, (ConversionService)this.conversionService);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                boolean isConstructorProperty = constructor.isConstructorParameter(prop);
                boolean hasValueForProperty = dbo.containsField(prop.getFieldName());
                if (!hasValueForProperty || isConstructorProperty) {
                    return;
                }
                Object obj = MappingMongoConverter.this.getValueInternal(prop, dbo, spelCtx, prop.getSpelExpression());
                wrapper.setProperty((PersistentProperty)prop, obj, MappingMongoConverter.this.useFieldAccessOnly);
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object obj = MappingMongoConverter.this.getValueInternal(inverseProp, dbo, spelCtx, inverseProp.getSpelExpression());
                try {
                    wrapper.setProperty((PersistentProperty)inverseProp, obj);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        return (S)wrapper.getBean();
    }

    public void write(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        boolean handledByCustomConverter = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class) != null;
        TypeInformation type = ClassTypeInformation.from(obj.getClass());
        if (!handledByCustomConverter && !(dbo instanceof BasicDBList)) {
            this.typeMapper.writeType(type, dbo);
        }
        this.writeInternal(obj, dbo, type);
    }

    protected void writeInternal(Object obj, DBObject dbo, TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.writeMapInternal((Map)obj, dbo, ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            this.writeCollectionInternal((Collection)obj, ClassTypeInformation.LIST, (BasicDBList)dbo);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass());
        this.writeInternal(obj, dbo, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, dbo);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            try {
                Object id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
                dbo.put("_id", this.idMapper.convertId(id));
            }
            catch (ConversionException ignored) {
                // empty catch block
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (prop.equals(idProperty)) {
                    return;
                }
                Object propertyObj = wrapper.getProperty((PersistentProperty)prop, prop.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                if (null != propertyObj) {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(propertyObj, dbo, prop.getFieldName());
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                Class type;
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object propertyObj = wrapper.getProperty((PersistentProperty)inverseProp, type = inverseProp.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, inverseProp);
                }
            }
        });
    }

    protected void writePropertyInternal(Object obj, DBObject dbo, MongoPersistentProperty prop) {
        com.mongodb.DBRef dbRefObj;
        if (obj == null) {
            return;
        }
        String name = prop.getFieldName();
        TypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            DBObject collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            dbo.put(name, (Object)collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            BasicDBObject mapDbObj = new BasicDBObject();
            this.writeMapInternal((Map)obj, (DBObject)mapDbObj, type);
            dbo.put(name, (Object)mapDbObj);
            return;
        }
        if (prop.isDbReference() && null != (dbRefObj = this.createDBRef(obj, prop.getDBRef()))) {
            dbo.put(name, (Object)dbRefObj);
            return;
        }
        Class<?> basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null);
        if (basicTargetType != null) {
            dbo.put(name, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        BasicDBObject propDbObj = new BasicDBObject();
        this.addCustomTypeKeyIfNecessary(type, obj, (DBObject)propDbObj);
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        this.writeInternal(obj, (DBObject)propDbObj, entity);
        dbo.put(name, (Object)propDbObj);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected DBObject createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new BasicDBList());
        }
        BasicDBList dbList = new BasicDBList();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property.getDBRef());
            dbList.add((Object)dbRef);
        }
        return dbList;
    }

    private BasicDBList writeCollectionInternal(Collection<?> source, TypeInformation<?> type, BasicDBList sink) {
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                sink.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                sink.add((Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(element), componentType, new BasicDBList()));
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, componentType);
            sink.add((Object)propDbObj);
        }
        return sink;
    }

    protected DBObject writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, dbo, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    dbo.put(simpleKey, (Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(val), propertyType.getMapValueType(), new BasicDBList()));
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                TypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (DBObject)newDbo, valueTypeInfo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbo;
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : type;
        Class reference = actualType == null ? Object.class : actualType.getType();
        boolean bl = notTheSameClass = !value.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(value.getClass(), dbObject);
        }
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, String key) {
        dbObject.put(key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, DBRef dbref) {
        String dbname;
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        if (null == targetEntity || null == targetEntity.getIdProperty()) {
            return null;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        BeanWrapper wrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
        Object id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
        if (null == id) {
            throw new MappingException("Cannot create a reference to an object with a NULL id.");
        }
        String collection = dbref.collection();
        if ("".equals(collection)) {
            collection = targetEntity.getCollection();
        }
        DB db = StringUtils.hasText((String)(dbname = dbref.db())) ? this.mongoDbFactory.getDb(dbname) : this.mongoDbFactory.getDb();
        return new com.mongodb.DBRef(db, collection, this.idMapper.convertId(id));
    }

    protected Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, StandardEvaluationContext ctx, String spelExpr) {
        Object o;
        if (null != spelExpr) {
            Expression x = this.spelExpressionParser.parseExpression(spelExpr);
            o = x.getValue((EvaluationContext)ctx);
        } else {
            Object sourceValue = dbo.get(prop.getFieldName());
            if (sourceValue == null) {
                return null;
            }
            Class propertyType = prop.getType();
            if (this.conversions.hasCustomReadTarget(sourceValue.getClass(), propertyType)) {
                return this.conversionService.convert(sourceValue, propertyType);
            }
            if (sourceValue instanceof com.mongodb.DBRef) {
                sourceValue = ((com.mongodb.DBRef)sourceValue).fetch();
            }
            if (sourceValue instanceof DBObject) {
                if (prop.isMap()) {
                    return this.readMap(prop.getTypeInformation(), (DBObject)sourceValue);
                }
                if (prop.isArray() && sourceValue instanceof BasicDBObject && ((DBObject)sourceValue).keySet().size() == 0) {
                    return Array.newInstance(prop.getComponentType(), 0);
                }
                if (prop.isCollectionLike() && sourceValue instanceof BasicDBList) {
                    return this.readCollectionOrArray(prop.getTypeInformation(), (BasicDBList)sourceValue);
                }
                TypeInformation toType = this.typeMapper.readType((DBObject)sourceValue, prop.getTypeInformation());
                o = toType != null ? this.read(toType, (DBObject)sourceValue) : this.read((MongoPersistentEntity)this.mappingContext.getPersistentEntity(prop.getTypeInformation()), (DBObject)sourceValue);
            } else {
                o = sourceValue;
            }
        }
        return o;
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, BasicDBList sourceValue) {
        Assert.notNull(targetType);
        Class<List> collectionType = targetType.getType();
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        Collection<Object> items = targetType.getType().isArray() ? new ArrayList() : CollectionFactory.createCollection(collectionType, (int)sourceValue.size());
        for (int i = 0; i < sourceValue.size(); ++i) {
            Object dbObjItem = sourceValue.get(i);
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(this.read(targetType.getComponentType(), ((com.mongodb.DBRef)dbObjItem).fetch()));
                continue;
            }
            if (dbObjItem instanceof DBObject) {
                items.add(this.read(targetType.getComponentType(), (DBObject)dbObjItem));
                continue;
            }
            TypeInformation componentType = targetType.getComponentType();
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, componentType == null ? null : componentType.getType()));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject) {
        Assert.notNull((Object)dbObject);
        Class mapType = this.typeMapper.readType(dbObject, type).getType();
        Map map = CollectionFactory.createMap((Class)mapType, (int)dbObject.keySet().size());
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey((String)entry.getKey());
            TypeInformation keyTypeInformation = type.getComponentType();
            if (keyTypeInformation != null) {
                Class keyType = keyTypeInformation.getType();
                key = this.conversionService.convert(key, keyType);
            }
            Object value = entry.getValue();
            TypeInformation valueType = type.getMapValueType();
            if (value instanceof DBObject) {
                map.put(key, this.read(valueType, (DBObject)value));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    protected <T> List<?> unwrapList(BasicDBList dbList, TypeInformation<T> targetType) {
        ArrayList<Object> rootList = new ArrayList<Object>();
        for (int i = 0; i < dbList.size(); ++i) {
            Object obj = dbList.get(i);
            if (obj instanceof BasicDBList) {
                rootList.add(this.unwrapList((BasicDBList)obj, targetType.getComponentType()));
                continue;
            }
            if (obj instanceof DBObject) {
                rootList.add(this.read(targetType, (DBObject)obj));
                continue;
            }
            rootList.add(obj);
        }
        return rootList;
    }

    @Override
    public Object convertToMongoType(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (null != obj && this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((Iterable<?>)((BasicDBList)obj));
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            BasicDBObject result = new BasicDBObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue()));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj));
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        return this.removeTypeInfoRecursively(newDbo);
    }

    public BasicDBList maybeConvertList(Iterable<?> source) {
        BasicDBList newDbl = new BasicDBList();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element));
        }
        return newDbl;
    }

    private Object removeTypeInfoRecursively(Object object) {
        if (!(object instanceof DBObject)) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        String keyToRemove = null;
        for (String key : dbObject.keySet()) {
            Object value;
            if (this.typeMapper.isTypeKey(key)) {
                keyToRemove = key;
            }
            if ((value = dbObject.get(key)) instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value);
        }
        if (keyToRemove != null) {
            dbObject.removeField(keyToRemove);
        }
        return dbObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingParameterValueProvider
    implements ParameterValueProvider {
        private final DBObject source;
        private final ParameterValueProvider delegate;
        private final MappedConstructor constructor;

        public DelegatingParameterValueProvider(MappedConstructor constructor, DBObject source, SpELAwareParameterValueProvider delegate) {
            Assert.notNull((Object)constructor);
            Assert.notNull((Object)source);
            Assert.notNull((Object)delegate);
            this.constructor = constructor;
            this.source = source;
            this.delegate = delegate;
        }

        public <T> T getParameterValue(PreferredConstructor.Parameter<T> parameter) {
            MappedConstructor.MappedParameter mappedParameter = this.constructor.getFor(parameter);
            Object value = mappedParameter.hasSpELExpression() ? this.delegate.getParameterValue(parameter) : this.source.get(mappedParameter.getFieldName());
            TypeInformation<?> type = mappedParameter.getPropertyTypeInformation();
            if (value instanceof com.mongodb.DBRef) {
                return (T)MappingMongoConverter.this.read(type, ((com.mongodb.DBRef)value).fetch());
            }
            if (value instanceof BasicDBList) {
                return (T)MappingMongoConverter.this.getPotentiallyConvertedSimpleRead(MappingMongoConverter.this.readCollectionOrArray(type, (BasicDBList)value), type.getType());
            }
            if (value instanceof DBObject) {
                return (T)MappingMongoConverter.this.read(type, (DBObject)value);
            }
            return (T)MappingMongoConverter.this.getPotentiallyConvertedSimpleRead(value, type.getType());
        }
    }
}

