/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections15.Transformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.QueryMapper;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDslMongoRepository<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private final MongodbSerializer serializer;
    private final PathBuilder<T> builder;

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QueryDslMongoRepository(MongoEntityInformation<T, ID> entityInformation, MongoOperations mongoOperations, EntityPathResolver resolver) {
        super(entityInformation, mongoOperations);
        Assert.notNull((Object)resolver);
        EntityPath path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(path.getType(), path.getMetadata());
        this.serializer = new SpringDataMongodbSerializer(mongoOperations.getConverter());
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQueryFor(predicate).uniqueResult();
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQueryFor(predicate).list();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.createQueryFor(predicate).orderBy(orders).list();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        MongodbQuery<T> countQuery = this.createQueryFor(predicate);
        MongodbQuery<T> query = this.createQueryFor(predicate);
        return new PageImpl(this.applyPagination(query, pageable).list(), pageable, countQuery.count());
    }

    public long count(Predicate predicate) {
        return this.createQueryFor(predicate).count();
    }

    private MongodbQuery<T> createQueryFor(Predicate predicate) {
        DBCollection collection = this.getMongoOperations().getCollection(this.getEntityInformation().getCollectionName());
        MongodbQuery query = new MongodbQuery(collection, new Transformer<DBObject, T>(){

            public T transform(DBObject input) {
                Class type = QueryDslMongoRepository.this.getEntityInformation().getJavaType();
                return QueryDslMongoRepository.this.getMongoOperations().getConverter().read(type, input);
            }
        }, this.serializer);
        return query.where(new Predicate[]{predicate});
    }

    private MongodbQuery<T> applyPagination(MongodbQuery<T> query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query = query.offset((long)pageable.getOffset()).limit((long)pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    private MongodbQuery<T> applySorting(MongodbQuery<T> query, Sort sort) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpringDataMongodbSerializer
    extends MongodbSerializer {
        private final MongoConverter converter;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final QueryMapper mapper;

        public SpringDataMongodbSerializer(MongoConverter converter) {
            this.mappingContext = converter.getMappingContext();
            this.converter = converter;
            this.mapper = new QueryMapper(converter);
        }

        protected String getKeyForPath(Path<?> expr, PathMetadata<?> metadata) {
            Path parent = metadata.getParent();
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
            MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(metadata.getExpression().toString());
            return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
        }

        protected DBObject asDBObject(String key, Object value) {
            if ("_id".equals(key)) {
                return super.asDBObject(key, this.mapper.convertId(value));
            }
            return super.asDBObject(key, value instanceof Pattern ? value : this.converter.convertToMongoType(value));
        }
    }
}

