/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GridFsResource
extends InputStreamResource {
    static final String CONTENT_TYPE_FIELD = "_contentType";
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    @Nullable
    private final GridFSFile file;
    private final String filename;

    private GridFsResource(String filename) {
        super((InputStream)EMPTY_INPUT_STREAM, String.format("GridFs resource [%s]", filename));
        this.file = null;
        this.filename = filename;
    }

    public GridFsResource(GridFSFile file) {
        this(file, new ByteArrayInputStream(new byte[0]));
    }

    public GridFsResource(GridFSFile file, InputStream inputStream) {
        super(inputStream, String.format("GridFs resource [%s]", file.getFilename()));
        this.file = file;
        this.filename = file.getFilename();
    }

    public static GridFsResource absent(String filename) {
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        return new GridFsResource(filename);
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        this.verifyExists();
        return super.getInputStream();
    }

    public long contentLength() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    public boolean exists() {
        return this.file != null;
    }

    public long lastModified() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getUploadDate().getTime();
    }

    public String getDescription() {
        return String.format("GridFs resource [%s]", this.getFilename());
    }

    public Object getId() {
        Assert.state((boolean)this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return this.getGridFSFile().getId();
    }

    @Nullable
    public GridFSFile getGridFSFile() {
        return this.file;
    }

    public String getContentType() {
        Assert.state((boolean)this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return (String)Optionals.firstNonEmpty((Supplier[])new Supplier[]{() -> Optional.ofNullable(this.getGridFSFile().getMetadata()).map(it -> (String)it.get((Object)CONTENT_TYPE_FIELD, String.class)), () -> Optional.ofNullable(this.getGridFSFile().getContentType())}).orElseThrow(() -> new MongoGridFSException("No contentType data for this GridFS file"));
    }

    private void verifyExists() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist.", this.getDescription()));
        }
    }
}

