/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SetWindowFieldsOperation
implements AggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private static final String CURRENT = "current";
    private static final String UNBOUNDED = "unbounded";
    @Nullable
    private final Object partitionBy;
    @Nullable
    private final AggregationOperation sortBy;
    private final WindowOutput output;

    protected SetWindowFieldsOperation(@Nullable Object partitionBy, @Nullable AggregationOperation sortBy, WindowOutput output) {
        this.partitionBy = partitionBy;
        this.sortBy = sortBy;
        this.output = output;
    }

    public static SetWindowFieldsOperationBuilder builder() {
        return new SetWindowFieldsOperationBuilder();
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.nonSynthetic(Fields.from(this.output.fields.toArray(new Field[0])));
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document $setWindowFields = new Document();
        if (this.partitionBy != null) {
            Object object = this.partitionBy;
            if (object instanceof AggregationExpression) {
                AggregationExpression aggregationExpression = (AggregationExpression)object;
                $setWindowFields.append("partitionBy", (Object)aggregationExpression.toDocument(context));
            } else {
                object = this.partitionBy;
                if (object instanceof Field) {
                    Field field = (Field)object;
                    $setWindowFields.append("partitionBy", (Object)context.getReference(field).toString());
                } else {
                    $setWindowFields.append("partitionBy", this.partitionBy);
                }
            }
        }
        if (this.sortBy != null) {
            $setWindowFields.append("sortBy", this.sortBy.toDocument(context).get((Object)this.sortBy.getOperator()));
        }
        Document output = new Document();
        for (ComputedField field : this.output.fields) {
            Document fieldOperation = field.getWindowOperator().toDocument(context);
            if (field.window != null) {
                fieldOperation.put("window", (Object)field.window.toDocument(context));
            }
            output.append(field.getName(), (Object)fieldOperation);
        }
        $setWindowFields.append("output", (Object)output);
        return new Document(this.getOperator(), (Object)$setWindowFields);
    }

    @Override
    public String getOperator() {
        return "$setWindowFields";
    }

    public static class WindowOutput {
        private final List<ComputedField> fields;

        public WindowOutput(ComputedField outputField) {
            Assert.notNull((Object)outputField, (String)"OutputField must not be null");
            this.fields = new ArrayList<ComputedField>();
            this.fields.add(outputField);
        }

        public WindowOutput append(ComputedField field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            this.fields.add(field);
            return this;
        }

        public ComputedFieldAppender append(final AggregationExpression expression) {
            return new ComputedFieldAppender(){
                @Nullable
                private Window window;

                @Override
                public WindowOutput as(String fieldname) {
                    return this.append(new ComputedField(fieldname, expression, this.window));
                }

                @Override
                public ComputedFieldAppender within(Window window) {
                    this.window = window;
                    return this;
                }
            };
        }

        static interface ComputedFieldAppender {
            public WindowOutput as(String var1);

            public ComputedFieldAppender within(Window var1);
        }
    }

    public static class SetWindowFieldsOperationBuilder {
        private Object partitionBy;
        private SortOperation sortOperation;
        private WindowOutput output;

        public SetWindowFieldsOperationBuilder partitionByField(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Field name must not be empty or null");
            return this.partitionBy(Fields.field("$" + fieldName, fieldName));
        }

        public SetWindowFieldsOperationBuilder partitionByExpression(AggregationExpression expression) {
            return this.partitionBy(expression);
        }

        public SetWindowFieldsOperationBuilder sortBy(String ... fields) {
            return this.sortBy(Sort.by((String[])fields));
        }

        public SetWindowFieldsOperationBuilder sortBy(Sort sort) {
            return this.sortBy(new SortOperation(sort));
        }

        public SetWindowFieldsOperationBuilder sortBy(SortOperation sort) {
            Assert.notNull((Object)sort, (String)"SortOperation must not be null");
            this.sortOperation = sort;
            return this;
        }

        public SetWindowFieldsOperationBuilder output(WindowOutput output) {
            Assert.notNull((Object)output, (String)"WindowOutput must not be null");
            this.output = output;
            return this;
        }

        public WindowChoice output(final AggregationExpression expression) {
            return new WindowChoice(){
                @Nullable
                private Window window;

                @Override
                public As within(Window window) {
                    Assert.notNull((Object)window, (String)"Window must not be null");
                    this.window = window;
                    return this;
                }

                @Override
                public SetWindowFieldsOperationBuilder as(String targetFieldName) {
                    Assert.hasText((String)targetFieldName, (String)"Target field name must not be empty or null");
                    ComputedField computedField = new ComputedField(targetFieldName, expression, this.window);
                    if (output == null) {
                        output = new WindowOutput(computedField);
                    } else {
                        output.append(computedField);
                    }
                    return this;
                }
            };
        }

        public SetWindowFieldsOperationBuilder partitionBy(Object value) {
            Assert.notNull((Object)value, (String)"Partition By must not be null");
            this.partitionBy = value;
            return this;
        }

        public SetWindowFieldsOperation build() {
            return new SetWindowFieldsOperation(this.partitionBy, this.sortOperation, this.output);
        }

        public static interface WindowChoice
        extends As {
            public As within(Window var1);
        }

        public static interface As {
            public SetWindowFieldsOperationBuilder as(String var1);
        }
    }

    public static class ComputedField
    implements Field {
        private final String name;
        private final AggregationExpression windowOperator;
        @Nullable
        private final Window window;

        public ComputedField(String name, AggregationExpression windowOperator) {
            this(name, windowOperator, null);
        }

        public ComputedField(String name, AggregationExpression windowOperator, @Nullable Window window) {
            this.name = name;
            this.windowOperator = windowOperator;
            this.window = window;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTarget() {
            return this.getName();
        }

        @Override
        public boolean isAliased() {
            return false;
        }

        public AggregationExpression getWindowOperator() {
            return this.windowOperator;
        }

        public Window getWindow() {
            return this.window;
        }
    }

    public static interface Window {
        public Object getLower();

        public Object getUpper();

        default public Document toDocument() {
            return this.toDocument(Aggregation.DEFAULT_CONTEXT);
        }

        public Document toDocument(AggregationOperationContext var1);
    }

    public static enum WindowUnits implements WindowUnit
    {
        DEFAULT,
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    public static interface WindowUnit {
        public String name();

        public static WindowUnit from(TimeUnit timeUnit) {
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            switch (timeUnit) {
                case DAYS: {
                    return WindowUnits.DAY;
                }
                case HOURS: {
                    return WindowUnits.HOUR;
                }
                case MINUTES: {
                    return WindowUnits.MINUTE;
                }
                case SECONDS: {
                    return WindowUnits.SECOND;
                }
                case MILLISECONDS: {
                    return WindowUnits.MILLISECOND;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot create WindowUnit from %s", new Object[]{timeUnit}));
        }

        public static WindowUnit from(ChronoUnit chronoUnit) {
            switch (chronoUnit) {
                case YEARS: {
                    return WindowUnits.YEAR;
                }
                case WEEKS: {
                    return WindowUnits.WEEK;
                }
                case MONTHS: {
                    return WindowUnits.MONTH;
                }
                case DAYS: {
                    return WindowUnits.DAY;
                }
                case HOURS: {
                    return WindowUnits.HOUR;
                }
                case MINUTES: {
                    return WindowUnits.MINUTE;
                }
                case SECONDS: {
                    return WindowUnits.SECOND;
                }
                case MILLIS: {
                    return WindowUnits.MILLISECOND;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot create WindowUnit from %s", chronoUnit));
        }
    }

    public static class RangeWindow
    extends WindowImpl {
        private final WindowUnit unit;

        protected RangeWindow(Object lower, Object upper, WindowUnit unit) {
            super(lower, upper);
            this.unit = unit;
        }

        @Override
        public Document toDocument(AggregationOperationContext ctx) {
            Document range = new Document("range", (Object)new Object[]{this.getLower(), this.getUpper()});
            if (this.unit != null && !WindowUnits.DEFAULT.equals(this.unit)) {
                range.append("unit", (Object)this.unit.name().toLowerCase());
            }
            return range;
        }
    }

    public static class DocumentWindow
    extends WindowImpl {
        DocumentWindow(Object lower, Object upper) {
            super(lower, upper);
        }

        @Override
        public Document toDocument(AggregationOperationContext ctx) {
            return new Document("documents", Arrays.asList(this.getLower(), this.getUpper()));
        }
    }

    static abstract class WindowImpl
    implements Window {
        private final Object lower;
        private final Object upper;

        protected WindowImpl(Object lower, Object upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public Object getLower() {
            return this.lower;
        }

        @Override
        public Object getUpper() {
            return this.upper;
        }
    }

    public static class DocumentWindowBuilder {
        @Nullable
        private Object lower;
        @Nullable
        private Object upper;

        public DocumentWindowBuilder from(Number lower) {
            this.lower = lower;
            return this;
        }

        public DocumentWindowBuilder fromCurrent() {
            return this.from(SetWindowFieldsOperation.CURRENT);
        }

        public DocumentWindowBuilder fromUnbounded() {
            return this.from(SetWindowFieldsOperation.UNBOUNDED);
        }

        public DocumentWindowBuilder to(String upper) {
            this.upper = upper;
            return this;
        }

        public DocumentWindowBuilder from(String lower) {
            this.lower = lower;
            return this;
        }

        public DocumentWindowBuilder to(Number upper) {
            this.upper = upper;
            return this;
        }

        public DocumentWindowBuilder toCurrent() {
            return this.to(SetWindowFieldsOperation.CURRENT);
        }

        public DocumentWindowBuilder toUnbounded() {
            return this.to(SetWindowFieldsOperation.UNBOUNDED);
        }

        public DocumentWindow build() {
            Assert.notNull((Object)this.lower, (String)"Lower bound must not be null");
            Assert.notNull((Object)this.upper, (String)"Upper bound must not be null");
            return new DocumentWindow(this.lower, this.upper);
        }
    }

    public static class RangeWindowBuilder {
        @Nullable
        private Object lower;
        @Nullable
        private Object upper;
        @Nullable
        private WindowUnit unit;

        public RangeWindowBuilder from(String lower) {
            this.lower = lower;
            return this;
        }

        public RangeWindowBuilder to(String upper) {
            this.upper = upper;
            return this;
        }

        public RangeWindowBuilder from(Number lower) {
            this.lower = lower;
            return this;
        }

        public RangeWindowBuilder to(Number upper) {
            this.upper = upper;
            return this;
        }

        public RangeWindowBuilder fromCurrent() {
            return this.from(SetWindowFieldsOperation.CURRENT);
        }

        public RangeWindowBuilder fromUnbounded() {
            return this.from(SetWindowFieldsOperation.UNBOUNDED);
        }

        public RangeWindowBuilder toCurrent() {
            return this.to(SetWindowFieldsOperation.CURRENT);
        }

        public RangeWindowBuilder toUnbounded() {
            return this.to(SetWindowFieldsOperation.UNBOUNDED);
        }

        public RangeWindowBuilder unit(WindowUnit windowUnit) {
            Assert.notNull((Object)windowUnit, (String)"WindowUnit must not be null");
            this.unit = windowUnit;
            return this;
        }

        public RangeWindow build() {
            Assert.notNull((Object)this.lower, (String)"Lower bound must not be null");
            Assert.notNull((Object)this.upper, (String)"Upper bound must not be null");
            Assert.notNull((Object)this.unit, (String)"WindowUnit bound must not be null");
            return new RangeWindow(this.lower, this.upper, this.unit);
        }
    }

    public static interface Windows {
        public static DocumentWindow documents(Object lower, Object upper) {
            return new DocumentWindow(lower, upper);
        }

        public static RangeWindow range(Object lower, Object upper, @Nullable WindowUnit unit) {
            return new RangeWindow(lower, upper, unit == null ? WindowUnits.DEFAULT : unit);
        }

        public static RangeWindowBuilder range() {
            return new RangeWindowBuilder();
        }

        public static DocumentWindowBuilder documents() {
            return new DocumentWindowBuilder();
        }
    }
}

