/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.messaging.ChangeStreamRequest;
import org.springframework.data.mongodb.core.messaging.ChangeStreamTask;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.messaging.TailableCursorRequest;
import org.springframework.data.mongodb.core.messaging.TailableCursorTask;
import org.springframework.data.mongodb.core.messaging.Task;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

class TaskFactory {
    private final MongoTemplate tempate;

    TaskFactory(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null");
        this.tempate = template;
    }

    <S, T> Task forRequest(SubscriptionRequest<S, ? super T, ? extends SubscriptionRequest.RequestOptions> request, Class<T> targetType, ErrorHandler errorHandler) {
        Assert.notNull(request, (String)"Request must not be null");
        Assert.notNull(targetType, (String)"TargetType must not be null");
        if (request instanceof ChangeStreamRequest) {
            ChangeStreamRequest changeStreamRequest = (ChangeStreamRequest)request;
            return new ChangeStreamTask(this.tempate, changeStreamRequest, targetType, errorHandler);
        }
        if (request instanceof TailableCursorRequest) {
            TailableCursorRequest tailableCursorRequest = (TailableCursorRequest)request;
            return new TailableCursorTask(this.tempate, tailableCursorRequest, targetType, errorHandler);
        }
        throw new IllegalArgumentException("oh wow - seems you're using some fancy new feature we do not support; Please be so kind and leave us a note in the issue tracker so we can get this fixed\nThank you");
    }
}

