/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collections;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CurrencyFunction
extends AbstractFunction {
    private static final String OPERATION = "currency";

    private CurrencyFunction(Field field) {
        super(Collections.singletonList(field));
    }

    public static CurrencyFunction currency(String fieldName) {
        Assert.hasText((String)fieldName, (String)"FieldName must not be empty!");
        return CurrencyFunction.currency(fieldName, null);
    }

    public static CurrencyFunction currency(Field field) {
        return CurrencyFunction.currency(field, null);
    }

    public static CurrencyFunction currency(Field field, @Nullable String currencyCode) {
        Assert.notNull((Object)field, (String)"Field for currency function must not be 'null'.");
        CurrencyFunction function = new CurrencyFunction(field);
        if (StringUtils.hasText((String)currencyCode)) {
            function.addArgument(currencyCode);
        }
        return function;
    }

    public static CurrencyFunction currency(String fieldName, @Nullable String currencyCode) {
        Assert.hasText((String)fieldName, (String)"FieldName for currency function must not be 'empty'.");
        return CurrencyFunction.currency(new SimpleField(fieldName), currencyCode);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

