/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.result.StringPageKey;
import org.springframework.data.solr.core.query.result.TermsFieldEntry;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.util.Assert;

public class TermsResultPage
implements TermsPage {
    private Map<StringPageKey, List<TermsFieldEntry>> termsMap = new LinkedHashMap<StringPageKey, List<TermsFieldEntry>>(1);

    public final void addTermsResult(List<TermsFieldEntry> entries, Field field) {
        Assert.notNull((Object)field, (String)"Cannot add terms for 'null' field.");
        this.termsMap.put(new StringPageKey(field.getName()), entries);
    }

    public final void addTermsResult(List<TermsFieldEntry> entries, String fieldname) {
        Assert.notNull((Object)fieldname, (String)"Cannot add terms for 'null' field.");
        this.termsMap.put(new StringPageKey(fieldname), entries);
    }

    public void addAllTerms(Map<String, List<TermsFieldEntry>> pageMap) {
        for (Map.Entry<String, List<TermsFieldEntry>> entry : pageMap.entrySet()) {
            this.addTermsResult(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Iterable<TermsFieldEntry> getTermsForField(String fieldname) {
        List<TermsFieldEntry> terms = this.termsMap.get(new StringPageKey(fieldname));
        return terms != null ? terms : Collections.emptyList();
    }

    public Iterable<TermsFieldEntry> getTerms(Field field) {
        Assert.notNull((Object)field, (String)"Field cannot be null.");
        return this.getTermsForField(field.getName());
    }

    public Collection<Field> getTermsFields() {
        if (this.termsMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(this.termsMap.size());
        for (StringPageKey pageKey : this.termsMap.keySet()) {
            fields.add(new SimpleField(pageKey.getKey()));
        }
        return fields;
    }

    @Override
    public Iterator<TermsFieldEntry> iterator() {
        return this.getContent().iterator();
    }

    public List<TermsFieldEntry> getContent() {
        ArrayList<TermsFieldEntry> values = new ArrayList<TermsFieldEntry>();
        for (List<TermsFieldEntry> entries : this.termsMap.values()) {
            values.addAll(entries);
        }
        return values;
    }

    @Override
    public boolean hasContent() {
        return !this.termsMap.isEmpty();
    }
}

