/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.io.Closeable;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SolrClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(SolrClientUtils.class);
    private static final String SLASH = "/";

    private SolrClientUtils() {
    }

    public static String resolveSolrCoreName(Class<?> type) {
        SolrDocument annotation = (SolrDocument)AnnotationUtils.findAnnotation(type, SolrDocument.class);
        if (annotation != null && StringUtils.isNotBlank((CharSequence)annotation.solrCoreName())) {
            return annotation.solrCoreName();
        }
        return "";
    }

    public static void close(SolrClient solrClient) {
        Assert.notNull((Object)solrClient, (String)"SolrClient must not be null!");
        try {
            if (solrClient instanceof Closeable) {
                solrClient.close();
            } else {
                Method shutdownMethod = ReflectionUtils.findMethod(solrClient.getClass(), (String)"shutdown");
                if (shutdownMethod != null) {
                    shutdownMethod.invoke((Object)solrClient, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Cannot close SolrClient", (Throwable)e);
        }
    }
}

