/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.frs.object.AbstractObjectManagerStripe;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.terracotta.offheapstore.OffHeapHashMap;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;

public class OffHeapObjectManagerStripe<I>
extends AbstractObjectManagerStripe<I, ByteBuffer, ByteBuffer>
implements RestartableObject<I, ByteBuffer, ByteBuffer> {
    private final I identifier;
    private final AbstractConcurrentOffHeapMap<?, ?> concurrentMap;
    private final List<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> segments;

    public OffHeapObjectManagerStripe(I identifier, OffHeapHashMap<?, ?> map) {
        this(identifier, Collections.singletonList((ObjectManagerSegment)map.getStorageEngine()), null);
    }

    public OffHeapObjectManagerStripe(I identifier, AbstractConcurrentOffHeapMap<?, ?> map) {
        this(identifier, OffHeapObjectManagerStripe.getRestartableSegments(map), map);
    }

    protected OffHeapObjectManagerStripe(I identifier, List<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> segments, AbstractConcurrentOffHeapMap<?, ?> map) {
        this.identifier = identifier;
        this.segments = Collections.unmodifiableList(segments);
        this.concurrentMap = map;
    }

    public Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> getSegments() {
        return this.segments;
    }

    public void replayPut(ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        try {
            super.replayPut((Object)frsBinaryKey, (Object)frsBinaryValue, lsn);
        }
        catch (OversizeMappingException e) {
            if (this.concurrentMap instanceof AbstractConcurrentOffHeapCache) {
                AbstractConcurrentOffHeapCache concurrentCache = (AbstractConcurrentOffHeapCache)this.concurrentMap;
                int hashcode = this.extractHashCode(frsBinaryKey);
                if (concurrentCache.handleOversizeMappingException(hashcode)) {
                    try {
                        super.replayPut((Object)frsBinaryKey, (Object)frsBinaryValue, lsn);
                        return;
                    }
                    catch (OversizeMappingException ex) {
                        e = ex;
                    }
                }
                concurrentCache.writeLockAll();
                while (true) {
                    try {
                        super.replayPut((Object)frsBinaryKey, (Object)frsBinaryValue, lsn);
                        return;
                    }
                    catch (OversizeMappingException ex) {
                        e = ex;
                        if (concurrentCache.handleOversizeMappingException(hashcode)) continue;
                        throw e;
                    }
                    break;
                }
                finally {
                    concurrentCache.writeUnlockAll();
                }
            }
            throw e;
        }
    }

    protected ObjectManagerSegment<I, ByteBuffer, ByteBuffer> getSegmentFor(int hash, ByteBuffer key) {
        if (this.segments.size() == 1) {
            return this.segments.get(0);
        }
        return this.segments.get(this.concurrentMap.getIndexFor(hash));
    }

    protected int extractHashCode(ByteBuffer frsBinaryKey) {
        return RestartableStorageEngine.extractHashcode(frsBinaryKey);
    }

    private static <I> List<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> getRestartableSegments(AbstractConcurrentOffHeapMap<?, ?> map) {
        ArrayList<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> result = new ArrayList<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>>();
        for (Segment<?, ?> segment : map.getSegments()) {
            result.add((ObjectManagerSegment)((OffHeapHashMap)((Object)segment)).getStorageEngine());
        }
        return result;
    }

    public void delete() {
    }

    public I getId() {
        return this.identifier;
    }

    public ObjectManagerStripe<I, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return this;
    }
}

