/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.http.HttpException;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.ForwardingHttpAsyncResponseConsumer;
import org.zalando.logbook.httpclient.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookHttpAsyncResponseConsumer<T>
extends ForwardingHttpAsyncResponseConsumer<T> {
    private final HttpAsyncResponseConsumer<T> consumer;
    private org.apache.http.HttpResponse response;

    public LogbookHttpAsyncResponseConsumer(HttpAsyncResponseConsumer<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected HttpAsyncResponseConsumer<T> delegate() {
        return this.consumer;
    }

    @Override
    public void responseReceived(org.apache.http.HttpResponse response) throws IOException, HttpException {
        this.response = response;
        this.delegate().responseReceived(response);
    }

    @Override
    public void responseCompleted(HttpContext context) {
        Logbook.ResponseProcessingStage stage = this.find(context);
        try {
            stage.process((HttpResponse)new RemoteResponse(this.response)).write();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.delegate().responseCompleted(context);
    }

    private Logbook.ResponseProcessingStage find(HttpContext context) {
        return (Logbook.ResponseProcessingStage)context.getAttribute(Attributes.STAGE);
    }
}

