/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.PropertyName;

public class Ace {
    private static final PropertyName DEFAULT_PROPERTY = new PropertyName("DAV:", "owner");
    protected String principal;
    protected boolean negative = false;
    protected Vector privileges = new Vector();
    protected boolean protectedAce = false;
    protected boolean inherited = false;
    protected String inheritedFrom = null;
    protected PropertyName property = null;

    public Ace(String principal) {
        this.principal = principal;
    }

    public Ace(String principal, boolean negative, boolean protectedAce, boolean inherited, String inheritedFrom) {
        this(principal);
        this.negative = negative;
        this.protectedAce = protectedAce;
        this.inherited = inherited;
        this.inheritedFrom = inheritedFrom;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public boolean isProtected() {
        return this.protectedAce;
    }

    public void setProtected(boolean protectedAce) {
        this.protectedAce = protectedAce;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public void setInheritedFrom(String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public PropertyName getProperty() {
        return this.property != null ? this.property : DEFAULT_PROPERTY;
    }

    public void setProperty(PropertyName property) {
        this.property = property;
    }

    public Enumeration enumeratePrivileges() {
        return this.privileges.elements();
    }

    public void addPrivilege(Privilege privilege) {
        this.privileges.addElement(privilege);
    }

    public boolean removePrivilege(Privilege privilege) {
        return this.privileges.removeElement(privilege);
    }

    public void clearPrivileges() {
        this.privileges.clear();
    }

    public int hashCode() {
        return this.toString().hashCode() + (this.getPrincipal().equals("property") ? this.getProperty().hashCode() : 0);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Ace) {
            Ace otherAce = (Ace)o;
            boolean equals = true;
            equals &= this.isNegative() == otherAce.isNegative();
            equals &= this.isProtected() == otherAce.isProtected();
            if ((equals &= this.isInherited() == otherAce.isInherited()) && this.isInherited()) {
                equals = this.getInheritedFrom().equals(otherAce.getInheritedFrom());
            }
            if ((equals &= this.getPrincipal().equals(otherAce.getPrincipal())) && this.getPrincipal().equals("property")) {
                equals = this.getProperty().equals(otherAce.getProperty());
            }
            if (equals) {
                Enumeration privileges = this.enumeratePrivileges();
                Enumeration otherPrivileges = otherAce.enumeratePrivileges();
                while (equals && privileges.hasMoreElements()) {
                    equals = otherPrivileges.hasMoreElements();
                    if (!equals) continue;
                    equals = privileges.nextElement().equals(otherPrivileges.nextElement());
                }
                if (equals) {
                    equals = !otherPrivileges.hasMoreElements();
                }
            }
            return equals;
        }
        return false;
    }

    public String toString() {
        return (!this.isNegative() ? "granted" : "denied") + " to " + this.getPrincipal() + " (" + (this.isProtected() ? "protected" : "not protected") + ")" + " (" + (this.isInherited() ? "inherited from '" + this.getInheritedFrom() + "'" : "not inherited") + ")";
    }
}

