/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.query.internal.marshall;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.TraitType;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.protocols.query.internal.marshall.QueryMarshaller;
import software.amazon.awssdk.protocols.query.internal.marshall.QueryMarshallerContext;

@SdkInternalApi
public class ListQueryMarshaller
implements QueryMarshaller<List<?>> {
    private static final PathResolver AWS_QUERY_PATH_RESOLVER = (path, i, listTrait) -> listTrait.isFlattened() ? path + "." + (i + 1) : path + "." + listTrait.memberFieldInfo().locationName() + "." + (i + 1);
    private static final PathResolver EC2_QUERY_PATH_RESOLVER = (path, i, listTrait) -> path + "." + (i + 1);
    private static final EmptyListMarshaller AWS_QUERY_EMPTY_LIST_MARSHALLER = (context, path) -> context.request().putRawQueryParameter(path, "");
    private static final EmptyListMarshaller EC2_QUERY_EMPTY_LIST_MARSHALLER = (context, path) -> {};
    private final PathResolver pathResolver;
    private final EmptyListMarshaller emptyListMarshaller;

    private ListQueryMarshaller(PathResolver pathResolver, EmptyListMarshaller emptyListMarshaller) {
        this.pathResolver = pathResolver;
        this.emptyListMarshaller = emptyListMarshaller;
    }

    @Override
    public void marshall(QueryMarshallerContext context, String path, List<?> val, SdkField<List<?>> sdkField) {
        if (val.isEmpty() && !(val instanceof SdkAutoConstructList)) {
            this.emptyListMarshaller.marshall(context, path);
            return;
        }
        for (int i = 0; i < val.size(); ++i) {
            ListTrait listTrait = (ListTrait)sdkField.getTrait(ListTrait.class, TraitType.LIST_TRAIT);
            String listPath = this.pathResolver.resolve(path, i, listTrait);
            QueryMarshaller<Object> marshaller = context.marshallerRegistry().getMarshaller(listTrait.memberFieldInfo().marshallingType(), val);
            marshaller.marshall(context, listPath, val.get(i), (SdkField<Object>)listTrait.memberFieldInfo());
        }
    }

    public static ListQueryMarshaller awsQuery() {
        return new ListQueryMarshaller(AWS_QUERY_PATH_RESOLVER, AWS_QUERY_EMPTY_LIST_MARSHALLER);
    }

    public static ListQueryMarshaller ec2Query() {
        return new ListQueryMarshaller(EC2_QUERY_PATH_RESOLVER, EC2_QUERY_EMPTY_LIST_MARSHALLER);
    }

    @FunctionalInterface
    private static interface EmptyListMarshaller {
        public void marshall(QueryMarshallerContext var1, String var2);
    }

    @FunctionalInterface
    private static interface PathResolver {
        public String resolve(String var1, int var2, ListTrait var3);
    }
}

