/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TopicAliasingOptions {
    private OutboundTopicAliasBehaviorType outboundBehavior = OutboundTopicAliasBehaviorType.Default;
    private Integer outboundCacheMaxSize = 0;
    private InboundTopicAliasBehaviorType inboundBehavior = InboundTopicAliasBehaviorType.Default;
    private Integer inboundCacheMaxSize = 0;

    public TopicAliasingOptions withOutboundBehavior(OutboundTopicAliasBehaviorType behavior) {
        this.outboundBehavior = behavior;
        return this;
    }

    public TopicAliasingOptions withOutboundCacheMaxSize(int size) {
        this.outboundCacheMaxSize = size;
        return this;
    }

    public TopicAliasingOptions withInboundBehavior(InboundTopicAliasBehaviorType behavior) {
        this.inboundBehavior = behavior;
        return this;
    }

    public TopicAliasingOptions withInboundCacheMaxSize(int size) {
        this.inboundCacheMaxSize = size;
        return this;
    }

    public static enum OutboundTopicAliasBehaviorType {
        Default(0),
        Manual(1),
        LRU(2),
        Disabled(3);

        private int value;
        private static Map<Integer, OutboundTopicAliasBehaviorType> enumMapping;

        private OutboundTopicAliasBehaviorType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static OutboundTopicAliasBehaviorType getEnumValueFromInteger(int value) {
            OutboundTopicAliasBehaviorType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal OutboundTopicAliasBehaviorType");
        }

        private static Map<Integer, OutboundTopicAliasBehaviorType> buildEnumMapping() {
            return Stream.of(OutboundTopicAliasBehaviorType.values()).collect(Collectors.toMap(OutboundTopicAliasBehaviorType::getValue, Function.identity()));
        }

        static {
            enumMapping = OutboundTopicAliasBehaviorType.buildEnumMapping();
        }
    }

    public static enum InboundTopicAliasBehaviorType {
        Default(0),
        Enabled(1),
        Disabled(2);

        private int value;
        private static Map<Integer, InboundTopicAliasBehaviorType> enumMapping;

        private InboundTopicAliasBehaviorType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static InboundTopicAliasBehaviorType getEnumValueFromInteger(int value) {
            InboundTopicAliasBehaviorType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal InboundTopicAliasBehaviorType");
        }

        private static Map<Integer, InboundTopicAliasBehaviorType> buildEnumMapping() {
            return Stream.of(InboundTopicAliasBehaviorType.values()).collect(Collectors.toMap(InboundTopicAliasBehaviorType::getValue, Function.identity()));
        }

        static {
            enumMapping = InboundTopicAliasBehaviorType.buildEnumMapping();
        }
    }
}

