/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.crt.s3.ChecksumAlgorithm;

public class ChecksumConfig {
    private ChecksumLocation location = ChecksumLocation.NONE;
    private ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.NONE;
    private boolean validateChecksum = false;
    private List<ChecksumAlgorithm> validateChecksumAlgorithmList = null;

    public ChecksumConfig withChecksumLocation(ChecksumLocation location) {
        this.location = location;
        return this;
    }

    public ChecksumLocation getChecksumLocation() {
        return this.location;
    }

    public ChecksumConfig withChecksumAlgorithm(ChecksumAlgorithm algorithm) {
        this.checksumAlgorithm = algorithm;
        return this;
    }

    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public ChecksumConfig withValidateChecksum(boolean validateChecksum) {
        this.validateChecksum = validateChecksum;
        return this;
    }

    public boolean getValidateChecksum() {
        return this.validateChecksum;
    }

    public ChecksumConfig withValidateChecksumAlgorithmList(List<ChecksumAlgorithm> validateChecksumAlgorithmList) {
        this.validateChecksumAlgorithmList = validateChecksumAlgorithmList != null ? Collections.unmodifiableList(validateChecksumAlgorithmList) : null;
        return this;
    }

    public List<ChecksumAlgorithm> getValidateChecksumAlgorithmList() {
        return this.validateChecksumAlgorithmList;
    }

    public static enum ChecksumLocation {
        NONE(0),
        HEADER(1),
        TRAILER(2);

        private int nativeValue;

        private ChecksumLocation(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }
    }
}

