/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class OidcServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "oidc";

    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder().build();

    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder()
            .put("ap-northeast-1", "oidc.ap-northeast-1.amazonaws.com")
            .put("ap-northeast-2", "oidc.ap-northeast-2.amazonaws.com").put("ap-south-1", "oidc.ap-south-1.amazonaws.com")
            .put("ap-southeast-1", "oidc.ap-southeast-1.amazonaws.com")
            .put("ap-southeast-2", "oidc.ap-southeast-2.amazonaws.com").put("ca-central-1", "oidc.ca-central-1.amazonaws.com")
            .put("eu-central-1", "oidc.eu-central-1.amazonaws.com").put("eu-north-1", "oidc.eu-north-1.amazonaws.com")
            .put("eu-west-1", "oidc.eu-west-1.amazonaws.com").put("eu-west-2", "oidc.eu-west-2.amazonaws.com")
            .put("eu-west-3", "oidc.eu-west-3.amazonaws.com").put("us-east-1", "oidc.us-east-1.amazonaws.com")
            .put("us-east-2", "oidc.us-east-2.amazonaws.com").put("us-west-2", "oidc.us-west-2.amazonaws.com")
            .put("us-gov-west-1", "oidc.us-gov-west-1.amazonaws.com").build();

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-1"),
            Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"),
            Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-west-1"),
            Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("us-east-1"), Region.of("us-east-2"),
            Region.of("us-west-2"), Region.of("us-gov-west-1")));

    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.<String, String> builder()
            .put("ap-northeast-1", "ap-northeast-1").put("ap-northeast-2", "ap-northeast-2").put("ap-south-1", "ap-south-1")
            .put("ap-southeast-1", "ap-southeast-1").put("ap-southeast-2", "ap-southeast-2").put("ca-central-1", "ca-central-1")
            .put("eu-central-1", "eu-central-1").put("eu-north-1", "eu-north-1").put("eu-west-1", "eu-west-1")
            .put("eu-west-2", "eu-west-2").put("eu-west-3", "eu-west-3").put("us-east-1", "us-east-1")
            .put("us-east-2", "us-east-2").put("us-west-2", "us-west-2").put("us-gov-west-1", "us-gov-west-1").build();

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(
            new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-us-gov", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id())
                : computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}
