/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectLegalHoldRequest extends S3Request implements
        ToCopyableBuilder<PutObjectLegalHoldRequest.Builder, PutObjectLegalHoldRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectLegalHoldRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectLegalHoldRequest::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Key")
                    .unmarshallLocationName("Key").build()).build();

    private static final SdkField<ObjectLockLegalHold> LEGAL_HOLD_FIELD = SdkField
            .<ObjectLockLegalHold> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutObjectLegalHoldRequest::legalHold))
            .setter(setter(Builder::legalHold))
            .constructor(ObjectLockLegalHold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHold")
                    .unmarshallLocationName("LegalHold").build(), PayloadTrait.create()).build();

    private static final SdkField<String> REQUEST_PAYER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectLegalHoldRequest::requestPayerAsString))
            .setter(setter(Builder::requestPayer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-payer")
                    .unmarshallLocationName("x-amz-request-payer").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectLegalHoldRequest::versionId))
            .setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionId")
                    .unmarshallLocationName("versionId").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectLegalHoldRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD,
            LEGAL_HOLD_FIELD, REQUEST_PAYER_FIELD, VERSION_ID_FIELD, CONTENT_MD5_FIELD));

    private final String bucket;

    private final String key;

    private final ObjectLockLegalHold legalHold;

    private final String requestPayer;

    private final String versionId;

    private final String contentMD5;

    private PutObjectLegalHoldRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.legalHold = builder.legalHold;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
        this.contentMD5 = builder.contentMD5;
    }

    /**
     * <p>
     * The bucket name containing the object that you want to place a Legal Hold on.
     * </p>
     * <p>
     * When using this API with an access point, you must direct requests to the access point hostname. The access point
     * hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When
     * using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     * bucket name. For more information about access point ARNs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the
     * <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return The bucket name containing the object that you want to place a Legal Hold on. </p>
     *         <p>
     *         When using this API with an access point, you must direct requests to the access point hostname. The
     *         access point hostname takes the form
     *         <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
     *         operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     *         bucket name. For more information about access point ARNs, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a>
     *         in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The key name for the object that you want to place a Legal Hold on.
     * </p>
     * 
     * @return The key name for the object that you want to place a Legal Hold on.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * Container element for the Legal Hold configuration you want to apply to the specified object.
     * </p>
     * 
     * @return Container element for the Legal Hold configuration you want to apply to the specified object.
     */
    public ObjectLockLegalHold legalHold() {
        return legalHold;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerAsString() {
        return requestPayer;
    }

    /**
     * <p>
     * The version ID of the object that you want to place a Legal Hold on.
     * </p>
     * 
     * @return The version ID of the object that you want to place a Legal Hold on.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The MD5 hash for the request body.
     * </p>
     * 
     * @return The MD5 hash for the request body.
     */
    public String contentMD5() {
        return contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(legalHold());
        hashCode = 31 * hashCode + Objects.hashCode(requestPayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectLegalHoldRequest)) {
            return false;
        }
        PutObjectLegalHoldRequest other = (PutObjectLegalHoldRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(legalHold(), other.legalHold())
                && Objects.equals(requestPayerAsString(), other.requestPayerAsString())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(contentMD5(), other.contentMD5());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutObjectLegalHoldRequest").add("Bucket", bucket()).add("Key", key())
                .add("LegalHold", legalHold()).add("RequestPayer", requestPayerAsString()).add("VersionId", versionId())
                .add("ContentMD5", contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "LegalHold":
            return Optional.ofNullable(clazz.cast(legalHold()));
        case "RequestPayer":
            return Optional.ofNullable(clazz.cast(requestPayerAsString()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectLegalHoldRequest, T> g) {
        return obj -> g.apply((PutObjectLegalHoldRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectLegalHoldRequest> {
        /**
         * <p>
         * The bucket name containing the object that you want to place a Legal Hold on.
         * </p>
         * <p>
         * When using this API with an access point, you must direct requests to the access point hostname. The access
         * point hostname takes the form
         * <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation
         * using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For
         * more information about access point ARNs, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in
         * the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * 
         * @param bucket
         *        The bucket name containing the object that you want to place a Legal Hold on. </p>
         *        <p>
         *        When using this API with an access point, you must direct requests to the access point hostname. The
         *        access point hostname takes the form
         *        <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
         *        operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
         *        bucket name. For more information about access point ARNs, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access
         *        Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The key name for the object that you want to place a Legal Hold on.
         * </p>
         * 
         * @param key
         *        The key name for the object that you want to place a Legal Hold on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Container element for the Legal Hold configuration you want to apply to the specified object.
         * </p>
         * 
         * @param legalHold
         *        Container element for the Legal Hold configuration you want to apply to the specified object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHold(ObjectLockLegalHold legalHold);

        /**
         * <p>
         * Container element for the Legal Hold configuration you want to apply to the specified object.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectLockLegalHold.Builder} avoiding the need
         * to create one manually via {@link ObjectLockLegalHold#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectLockLegalHold.Builder#build()} is called immediately and
         * its result is passed to {@link #legalHold(ObjectLockLegalHold)}.
         * 
         * @param legalHold
         *        a consumer that will call methods on {@link ObjectLockLegalHold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalHold(ObjectLockLegalHold)
         */
        default Builder legalHold(Consumer<ObjectLockLegalHold.Builder> legalHold) {
            return legalHold(ObjectLockLegalHold.builder().applyMutation(legalHold).build());
        }

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * <p>
         * The version ID of the object that you want to place a Legal Hold on.
         * </p>
         * 
         * @param versionId
         *        The version ID of the object that you want to place a Legal Hold on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The MD5 hash for the request body.
         * </p>
         * 
         * @param contentMD5
         *        The MD5 hash for the request body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private ObjectLockLegalHold legalHold;

        private String requestPayer;

        private String versionId;

        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectLegalHoldRequest model) {
            super(model);
            bucket(model.bucket);
            key(model.key);
            legalHold(model.legalHold);
            requestPayer(model.requestPayer);
            versionId(model.versionId);
            contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final ObjectLockLegalHold.Builder getLegalHold() {
            return legalHold != null ? legalHold.toBuilder() : null;
        }

        @Override
        public final Builder legalHold(ObjectLockLegalHold legalHold) {
            this.legalHold = legalHold;
            return this;
        }

        public final void setLegalHold(ObjectLockLegalHold.BuilderImpl legalHold) {
            this.legalHold = legalHold != null ? legalHold.build() : null;
        }

        public final String getRequestPayerAsString() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer == null ? null : requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectLegalHoldRequest build() {
            return new PutObjectLegalHoldRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
