/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationJobResponse extends SmsResponse implements
        ToCopyableBuilder<CreateReplicationJobResponse.Builder, CreateReplicationJobResponse> {
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationJobId").getter(getter(CreateReplicationJobResponse::replicationJobId))
            .setter(setter(Builder::replicationJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_ID_FIELD));

    private final String replicationJobId;

    private CreateReplicationJobResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJobId = builder.replicationJobId;
    }

    /**
     * <p>
     * The unique identifier of the replication job.
     * </p>
     * 
     * @return The unique identifier of the replication job.
     */
    public final String replicationJobId() {
        return replicationJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationJobResponse)) {
            return false;
        }
        CreateReplicationJobResponse other = (CreateReplicationJobResponse) obj;
        return Objects.equals(replicationJobId(), other.replicationJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationJobResponse").add("ReplicationJobId", replicationJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationJobId":
            return Optional.ofNullable(clazz.cast(replicationJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationJobResponse, T> g) {
        return obj -> g.apply((CreateReplicationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicationJobResponse> {
        /**
         * <p>
         * The unique identifier of the replication job.
         * </p>
         * 
         * @param replicationJobId
         *        The unique identifier of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobId(String replicationJobId);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private String replicationJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationJobResponse model) {
            super(model);
            replicationJobId(model.replicationJobId);
        }

        public final String getReplicationJobId() {
            return replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        @Override
        public CreateReplicationJobResponse build() {
            return new CreateReplicationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
