/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a VM server location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VmServerAddress implements SdkPojo, Serializable, ToCopyableBuilder<VmServerAddress.Builder, VmServerAddress> {
    private static final SdkField<String> VM_MANAGER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerId").getter(getter(VmServerAddress::vmManagerId)).setter(setter(Builder::vmManagerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerId").build()).build();

    private static final SdkField<String> VM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vmId")
            .getter(getter(VmServerAddress::vmId)).setter(setter(Builder::vmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VM_MANAGER_ID_FIELD,
            VM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vmManagerId;

    private final String vmId;

    private VmServerAddress(BuilderImpl builder) {
        this.vmManagerId = builder.vmManagerId;
        this.vmId = builder.vmId;
    }

    /**
     * <p>
     * The ID of the VM manager.
     * </p>
     * 
     * @return The ID of the VM manager.
     */
    public final String vmManagerId() {
        return vmManagerId;
    }

    /**
     * <p>
     * The ID of the VM.
     * </p>
     * 
     * @return The ID of the VM.
     */
    public final String vmId() {
        return vmId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerId());
        hashCode = 31 * hashCode + Objects.hashCode(vmId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmServerAddress)) {
            return false;
        }
        VmServerAddress other = (VmServerAddress) obj;
        return Objects.equals(vmManagerId(), other.vmManagerId()) && Objects.equals(vmId(), other.vmId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VmServerAddress").add("VmManagerId", vmManagerId()).add("VmId", vmId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vmManagerId":
            return Optional.ofNullable(clazz.cast(vmManagerId()));
        case "vmId":
            return Optional.ofNullable(clazz.cast(vmId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VmServerAddress, T> g) {
        return obj -> g.apply((VmServerAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VmServerAddress> {
        /**
         * <p>
         * The ID of the VM manager.
         * </p>
         * 
         * @param vmManagerId
         *        The ID of the VM manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmManagerId(String vmManagerId);

        /**
         * <p>
         * The ID of the VM.
         * </p>
         * 
         * @param vmId
         *        The ID of the VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmId(String vmId);
    }

    static final class BuilderImpl implements Builder {
        private String vmManagerId;

        private String vmId;

        private BuilderImpl() {
        }

        private BuilderImpl(VmServerAddress model) {
            vmManagerId(model.vmManagerId);
            vmId(model.vmId);
        }

        public final String getVmManagerId() {
            return vmManagerId;
        }

        @Override
        public final Builder vmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
            return this;
        }

        public final void setVmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
        }

        public final String getVmId() {
            return vmId;
        }

        @Override
        public final Builder vmId(String vmId) {
            this.vmId = vmId;
            return this;
        }

        public final void setVmId(String vmId) {
            this.vmId = vmId;
        }

        @Override
        public VmServerAddress build() {
            return new VmServerAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
