/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.text.DateFormat;
import java.util.Calendar;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.ser.jdk.DateTimeSerializerBase;

@JacksonStdImpl
public class JavaUtilCalendarSerializer
extends DateTimeSerializerBase<Calendar> {
    public static final JavaUtilCalendarSerializer instance = new JavaUtilCalendarSerializer();

    public JavaUtilCalendarSerializer() {
        this(null, null);
    }

    public JavaUtilCalendarSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Calendar.class, useTimestamp, customFormat);
    }

    public JavaUtilCalendarSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new JavaUtilCalendarSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Calendar value) {
        return value == null ? 0L : value.getTimeInMillis();
    }

    @Override
    public void serialize(Calendar value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        if (this._asTimestamp(provider)) {
            g.writeNumber(this._timestamp(value));
            return;
        }
        this._serializeAsString(value.getTime(), g, provider);
    }
}

