/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.EnumDefinition;
import tools.jackson.databind.util.EnumValuesToWrite;

public abstract class JDKKeySerializers {
    protected static final ValueSerializer<Object> DEFAULT_STRING_SERIALIZER = new StringKeySerializer();

    public static ValueSerializer<Object> getStdKeySerializer(SerializationConfig config, Class<?> rawKeyType, boolean useDefault) {
        if (rawKeyType == null || rawKeyType == Object.class) {
            return new Dynamic();
        }
        if (rawKeyType == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (rawKeyType.isPrimitive()) {
            rawKeyType = ClassUtil.wrapperType(rawKeyType);
        }
        if (rawKeyType == Integer.class) {
            return new Default(5, rawKeyType);
        }
        if (rawKeyType == Long.class) {
            return new Default(6, rawKeyType);
        }
        if (rawKeyType.isPrimitive() || Number.class.isAssignableFrom(rawKeyType)) {
            return new Default(8, rawKeyType);
        }
        if (rawKeyType == Class.class) {
            return new Default(3, rawKeyType);
        }
        if (Date.class.isAssignableFrom(rawKeyType)) {
            return new Default(1, rawKeyType);
        }
        if (Calendar.class.isAssignableFrom(rawKeyType)) {
            return new Default(2, rawKeyType);
        }
        if (rawKeyType == UUID.class) {
            return new Default(8, rawKeyType);
        }
        if (rawKeyType == byte[].class) {
            return new Default(7, rawKeyType);
        }
        if (useDefault) {
            return new Default(8, rawKeyType);
        }
        return null;
    }

    public static ValueSerializer<Object> getFallbackKeySerializer(SerializationConfig config, Class<?> rawKeyType, AnnotatedClass annotatedClass) {
        if (rawKeyType != null) {
            if (rawKeyType == Enum.class) {
                return new Dynamic();
            }
            if (ClassUtil.isEnumType(rawKeyType)) {
                return EnumKeySerializer.construct(rawKeyType, EnumDefinition.construct(config, annotatedClass).valuesToWrite(config));
            }
        }
        return new Default(8, rawKeyType);
    }

    public static class Dynamic
    extends StdSerializer<Object> {
        protected transient PropertySerializerMap _dynamicSerializers = PropertySerializerMap.emptyForProperties();

        public Dynamic() {
            super(String.class);
        }

        Object readResolve() {
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            return this;
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            PropertySerializerMap m = this._dynamicSerializers;
            Class<?> cls = value.getClass();
            ValueSerializer<Object> ser = m.serializerFor(cls);
            if (ser == null) {
                ser = this._findAndAddDynamic(m, cls, provider);
            }
            ser.serialize(value, g, provider);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitStringFormat(visitor, typeHint);
        }

        protected ValueSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializationContext provider) {
            if (type == Object.class) {
                Default ser = new Default(8, type);
                this._dynamicSerializers = map.newWith(type, ser);
                return ser;
            }
            PropertySerializerMap.SerializerAndMapResult result = map.findAndAddKeySerializer(type, provider, null);
            if (map != result.map) {
                this._dynamicSerializers = result.map;
            }
            return result.serializer;
        }
    }

    public static class Default
    extends StdSerializer<Object> {
        static final int TYPE_DATE = 1;
        static final int TYPE_CALENDAR = 2;
        static final int TYPE_CLASS = 3;
        static final int TYPE_ENUM = 4;
        static final int TYPE_INTEGER = 5;
        static final int TYPE_LONG = 6;
        static final int TYPE_BYTE_ARRAY = 7;
        static final int TYPE_TO_STRING = 8;
        protected final int _typeId;

        public Default(int typeId, Class<?> type) {
            super(type);
            this._typeId = typeId;
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            switch (this._typeId) {
                case 1: {
                    provider.defaultSerializeDateKey((Date)value, g);
                    break;
                }
                case 2: {
                    provider.defaultSerializeDateKey(((Calendar)value).getTimeInMillis(), g);
                    break;
                }
                case 3: {
                    g.writeName(((Class)value).getName());
                    break;
                }
                case 4: {
                    String key;
                    if (provider.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING)) {
                        key = value.toString();
                    } else {
                        Enum e = (Enum)value;
                        key = provider.isEnabled(EnumFeature.WRITE_ENUM_KEYS_USING_INDEX) ? String.valueOf(e.ordinal()) : e.name();
                    }
                    g.writeName(key);
                    break;
                }
                case 5: 
                case 6: {
                    g.writePropertyId(((Number)value).longValue());
                    break;
                }
                case 7: {
                    String encoded = provider.getConfig().getBase64Variant().encode((byte[])value);
                    g.writeName(encoded);
                    break;
                }
                default: {
                    g.writeName(value.toString());
                }
            }
        }
    }

    public static class EnumKeySerializer
    extends StdSerializer<Object> {
        protected final EnumValuesToWrite _valuesToWrite;

        protected EnumKeySerializer(Class<?> enumType, EnumValuesToWrite valuesToWrite) {
            super(enumType);
            this._valuesToWrite = valuesToWrite;
        }

        public static EnumKeySerializer construct(Class<?> enumType, EnumValuesToWrite valuesToWrite) {
            return new EnumKeySerializer(enumType, valuesToWrite);
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
            Enum en = (Enum)value;
            if (ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING)) {
                g.writeName(this._valuesToWrite.fromToString(ctxt.getConfig(), en));
            } else if (ctxt.isEnabled(EnumFeature.WRITE_ENUM_KEYS_USING_INDEX)) {
                g.writeName(String.valueOf(en.ordinal()));
            } else {
                g.writeName(this._valuesToWrite.fromName(ctxt.getConfig(), en));
            }
        }
    }

    public static class StringKeySerializer
    extends StdSerializer<Object> {
        public StringKeySerializer() {
            super(String.class);
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            g.writeName((String)value);
        }
    }
}

