// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.StsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AssumeRoleOperationDeserializer: HttpDeserialize<AssumeRoleResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AssumeRoleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleError(context, call)
        }
        val builder = AssumeRoleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssumeRoleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAssumeRoleError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw StsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MalformedPolicyDocument" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "RegionDisabledException" -> RegionDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "PackedPolicyTooLarge" -> PackedPolicyTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        else -> StsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleOperationBody(builder: AssumeRoleResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AssumeRole")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AssumedRoleUser com.amazonaws.sts#AssumeRoleResponse$AssumedRoleUser
            "AssumedRoleUser" -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(curr)
            // Credentials com.amazonaws.sts#AssumeRoleResponse$Credentials
            "Credentials" -> builder.credentials = deserializeCredentialsDocument(curr)
            // PackedPolicySize com.amazonaws.sts#AssumeRoleResponse$PackedPolicySize
            "PackedPolicySize" -> builder.packedPolicySize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)" }
            // SourceIdentity com.amazonaws.sts#AssumeRoleResponse$SourceIdentity
            "SourceIdentity" -> builder.sourceIdentity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#sourceIdentityType`)" }
            else -> {}
        }
        curr.drop()
    }
}
