// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.auth

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.endpoints.internal.resolveEndpointParams
import aws.smithy.kotlin.runtime.auth.AuthOption
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.auth.AnonymousIdentity
import aws.smithy.kotlin.runtime.http.operation.AuthSchemeResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.http.operation.SdkHttpRequest
import aws.smithy.kotlin.runtime.http.request.immutableView

/**
 * Adapts the service specific auth scheme resolver to the agnostic runtime interface and binds the auth parameters
 */
internal class S3AuthSchemeProviderAdapter(private val config: S3Client.Config): AuthSchemeResolver {
    override suspend fun resolve(request: SdkHttpRequest): List<AuthOption> {
        val params = S3AuthSchemeParameters {
            operationName = request.context[SdkClientOption.OperationName]
            val resolveEndpointReq = ResolveEndpointRequest(request.context, request.subject.immutableView(), AnonymousIdentity)
            endpointParameters = resolveEndpointParams(config, resolveEndpointReq)
        }
        return config.authSchemeProvider.resolveAuthScheme(params)
    }
}
