// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * A lifecycle rule for individual objects in an Amazon S3 bucket.
 *
 * For more information see, [Managing your storage lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
 */
public class LifecycleRule private constructor(builder: Builder) {
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
     */
    public val abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3.model.AbortIncompleteMultipartUpload? = builder.abortIncompleteMultipartUpload
    /**
     * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
     */
    public val expiration: aws.sdk.kotlin.services.s3.model.LifecycleExpiration? = builder.expiration
    /**
     * The `Filter` is used to identify objects that a Lifecycle Rule applies to. A `Filter` must have exactly one of `Prefix`, `Tag`, or `And` specified. `Filter` is required if the `LifecycleRule` does not contain a `Prefix` element.
     */
    public val filter: aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter? = builder.filter
    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
     */
    public val noncurrentVersionExpiration: aws.sdk.kotlin.services.s3.model.NoncurrentVersionExpiration? = builder.noncurrentVersionExpiration
    /**
     * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
     */
    public val noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = builder.noncurrentVersionTransitions
    /**
     * Prefix identifying one or more objects to which the rule applies. This is no longer used; use `Filter` instead.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val prefix: kotlin.String? = builder.prefix
    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     */
    public val status: aws.sdk.kotlin.services.s3.model.ExpirationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Specifies when an Amazon S3 object transitions to a specified storage class.
     */
    public val transitions: List<Transition>? = builder.transitions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.LifecycleRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleRule(")
        append("abortIncompleteMultipartUpload=$abortIncompleteMultipartUpload,")
        append("expiration=$expiration,")
        append("filter=$filter,")
        append("id=$id,")
        append("noncurrentVersionExpiration=$noncurrentVersionExpiration,")
        append("noncurrentVersionTransitions=$noncurrentVersionTransitions,")
        append("prefix=$prefix,")
        append("status=$status,")
        append("transitions=$transitions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortIncompleteMultipartUpload?.hashCode() ?: 0
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionExpiration?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionTransitions?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (transitions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleRule

        if (abortIncompleteMultipartUpload != other.abortIncompleteMultipartUpload) return false
        if (expiration != other.expiration) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (noncurrentVersionExpiration != other.noncurrentVersionExpiration) return false
        if (noncurrentVersionTransitions != other.noncurrentVersionTransitions) return false
        if (prefix != other.prefix) return false
        if (status != other.status) return false
        if (transitions != other.transitions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.LifecycleRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
         */
        public var abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3.model.AbortIncompleteMultipartUpload? = null
        /**
         * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
         */
        public var expiration: aws.sdk.kotlin.services.s3.model.LifecycleExpiration? = null
        /**
         * The `Filter` is used to identify objects that a Lifecycle Rule applies to. A `Filter` must have exactly one of `Prefix`, `Tag`, or `And` specified. `Filter` is required if the `LifecycleRule` does not contain a `Prefix` element.
         */
        public var filter: aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter? = null
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.
         */
        public var noncurrentVersionExpiration: aws.sdk.kotlin.services.s3.model.NoncurrentVersionExpiration? = null
        /**
         * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
         */
        public var noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = null
        /**
         * Prefix identifying one or more objects to which the rule applies. This is no longer used; use `Filter` instead.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var prefix: kotlin.String? = null
        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         */
        public var status: aws.sdk.kotlin.services.s3.model.ExpirationStatus? = null
        /**
         * Specifies when an Amazon S3 object transitions to a specified storage class.
         */
        public var transitions: List<Transition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.LifecycleRule) : this() {
            this.abortIncompleteMultipartUpload = x.abortIncompleteMultipartUpload
            this.expiration = x.expiration
            this.filter = x.filter
            this.id = x.id
            this.noncurrentVersionExpiration = x.noncurrentVersionExpiration
            this.noncurrentVersionTransitions = x.noncurrentVersionTransitions
            this.prefix = x.prefix
            this.status = x.status
            this.transitions = x.transitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.LifecycleRule = LifecycleRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.AbortIncompleteMultipartUpload] inside the given [block]
         */
        public fun abortIncompleteMultipartUpload(block: aws.sdk.kotlin.services.s3.model.AbortIncompleteMultipartUpload.Builder.() -> kotlin.Unit) {
            this.abortIncompleteMultipartUpload = aws.sdk.kotlin.services.s3.model.AbortIncompleteMultipartUpload.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.LifecycleExpiration] inside the given [block]
         */
        public fun expiration(block: aws.sdk.kotlin.services.s3.model.LifecycleExpiration.Builder.() -> kotlin.Unit) {
            this.expiration = aws.sdk.kotlin.services.s3.model.LifecycleExpiration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.NoncurrentVersionExpiration] inside the given [block]
         */
        public fun noncurrentVersionExpiration(block: aws.sdk.kotlin.services.s3.model.NoncurrentVersionExpiration.Builder.() -> kotlin.Unit) {
            this.noncurrentVersionExpiration = aws.sdk.kotlin.services.s3.model.NoncurrentVersionExpiration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (status == null) status = ExpirationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
