// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class ListBucketInventoryConfigurationsRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket containing the inventory configurations to retrieve.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The marker used to continue an inventory configuration listing that has been truncated. Use the `NextContinuationToken` from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBucketInventoryConfigurationsRequest(")
        append("bucket=$bucket,")
        append("continuationToken=$continuationToken,")
        append("expectedBucketOwner=$expectedBucketOwner")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBucketInventoryConfigurationsRequest

        if (bucket != other.bucket) return false
        if (continuationToken != other.continuationToken) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket containing the inventory configurations to retrieve.
         */
        public var bucket: kotlin.String? = null
        /**
         * The marker used to continue an inventory configuration listing that has been truncated. Use the `NextContinuationToken` from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsRequest) : this() {
            this.bucket = x.bucket
            this.continuationToken = x.continuationToken
            this.expectedBucketOwner = x.expectedBucketOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListBucketInventoryConfigurationsRequest = ListBucketInventoryConfigurationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
