// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Request to filter the contents of an Amazon S3 object based on a simple Structured Query Language (SQL) statement. In the request, along with the SQL expression, you must specify a data serialization format (JSON or CSV) of the object. Amazon S3 uses this to parse object data into records. It returns only records that match the specified SQL expression. You must also specify the data serialization format for the response. For more information, see [S3Select API Documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectSELECTContent.html).
 */
public class SelectObjectContentRequest private constructor(builder: Builder) {
    /**
     * The S3 bucket.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The expression that is used to query the object.
     */
    public val expression: kotlin.String? = builder.expression
    /**
     * The type of the provided expression (for example, SQL).
     */
    public val expressionType: aws.sdk.kotlin.services.s3.model.ExpressionType? = builder.expressionType
    /**
     * Describes the format of the data in the object that is being queried.
     */
    public val inputSerialization: aws.sdk.kotlin.services.s3.model.InputSerialization? = builder.inputSerialization
    /**
     * The object key.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Describes the format of the data that you want Amazon S3 to return in response.
     */
    public val outputSerialization: aws.sdk.kotlin.services.s3.model.OutputSerialization? = builder.outputSerialization
    /**
     * Specifies if periodic request progress information should be enabled.
     */
    public val requestProgress: aws.sdk.kotlin.services.s3.model.RequestProgress? = builder.requestProgress
    /**
     * Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.
     *
     * `ScanRange`may be used in the following ways:
     * + `<scanrange><start>50</start><end>100</end></scanrange>` - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)
     * + `<scanrange><start>50</start></scanrange>` - process only the records starting after the byte 50
     * + `<scanrange><end>50</end></scanrange>` - process only the records within the last 50 bytes of the file.
     */
    public val scanRange: aws.sdk.kotlin.services.s3.model.ScanRange? = builder.scanRange
    /**
     * The server-side encryption (SSE) algorithm used to encrypt the object. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     */
    public val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * The server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     */
    public val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * The MD5 server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     */
    public val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelectObjectContentRequest(")
        append("bucket=$bucket,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("expression=$expression,")
        append("expressionType=$expressionType,")
        append("inputSerialization=$inputSerialization,")
        append("key=$key,")
        append("outputSerialization=$outputSerialization,")
        append("requestProgress=$requestProgress,")
        append("scanRange=$scanRange,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (expression?.hashCode() ?: 0)
        result = 31 * result + (expressionType?.hashCode() ?: 0)
        result = 31 * result + (inputSerialization?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (outputSerialization?.hashCode() ?: 0)
        result = 31 * result + (requestProgress?.hashCode() ?: 0)
        result = 31 * result + (scanRange?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelectObjectContentRequest

        if (bucket != other.bucket) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (expression != other.expression) return false
        if (expressionType != other.expressionType) return false
        if (inputSerialization != other.inputSerialization) return false
        if (key != other.key) return false
        if (outputSerialization != other.outputSerialization) return false
        if (requestProgress != other.requestProgress) return false
        if (scanRange != other.scanRange) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 bucket.
         */
        public var bucket: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The expression that is used to query the object.
         */
        public var expression: kotlin.String? = null
        /**
         * The type of the provided expression (for example, SQL).
         */
        public var expressionType: aws.sdk.kotlin.services.s3.model.ExpressionType? = null
        /**
         * Describes the format of the data in the object that is being queried.
         */
        public var inputSerialization: aws.sdk.kotlin.services.s3.model.InputSerialization? = null
        /**
         * The object key.
         */
        public var key: kotlin.String? = null
        /**
         * Describes the format of the data that you want Amazon S3 to return in response.
         */
        public var outputSerialization: aws.sdk.kotlin.services.s3.model.OutputSerialization? = null
        /**
         * Specifies if periodic request progress information should be enabled.
         */
        public var requestProgress: aws.sdk.kotlin.services.s3.model.RequestProgress? = null
        /**
         * Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.
         *
         * `ScanRange`may be used in the following ways:
         * + `<scanrange><start>50</start><end>100</end></scanrange>` - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)
         * + `<scanrange><start>50</start></scanrange>` - process only the records starting after the byte 50
         * + `<scanrange><end>50</end></scanrange>` - process only the records within the last 50 bytes of the file.
         */
        public var scanRange: aws.sdk.kotlin.services.s3.model.ScanRange? = null
        /**
         * The server-side encryption (SSE) algorithm used to encrypt the object. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         */
        public var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * The server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         */
        public var sseCustomerKey: kotlin.String? = null
        /**
         * The MD5 server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see [Protecting data using SSE-C keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         */
        public var sseCustomerKeyMd5: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest) : this() {
            this.bucket = x.bucket
            this.expectedBucketOwner = x.expectedBucketOwner
            this.expression = x.expression
            this.expressionType = x.expressionType
            this.inputSerialization = x.inputSerialization
            this.key = x.key
            this.outputSerialization = x.outputSerialization
            this.requestProgress = x.requestProgress
            this.scanRange = x.scanRange
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest = SelectObjectContentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.InputSerialization] inside the given [block]
         */
        public fun inputSerialization(block: aws.sdk.kotlin.services.s3.model.InputSerialization.Builder.() -> kotlin.Unit) {
            this.inputSerialization = aws.sdk.kotlin.services.s3.model.InputSerialization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.OutputSerialization] inside the given [block]
         */
        public fun outputSerialization(block: aws.sdk.kotlin.services.s3.model.OutputSerialization.Builder.() -> kotlin.Unit) {
            this.outputSerialization = aws.sdk.kotlin.services.s3.model.OutputSerialization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.RequestProgress] inside the given [block]
         */
        public fun requestProgress(block: aws.sdk.kotlin.services.s3.model.RequestProgress.Builder.() -> kotlin.Unit) {
            this.requestProgress = aws.sdk.kotlin.services.s3.model.RequestProgress.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ScanRange] inside the given [block]
         */
        public fun scanRange(block: aws.sdk.kotlin.services.s3.model.ScanRange.Builder.() -> kotlin.Unit) {
            this.scanRange = aws.sdk.kotlin.services.s3.model.ScanRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
