// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.waiters

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.model.HeadBucketRequest
import aws.sdk.kotlin.services.s3.model.HeadBucketResponse
import aws.sdk.kotlin.services.s3.model.HeadObjectRequest
import aws.sdk.kotlin.services.s3.model.HeadObjectResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import kotlin.time.Duration.Companion.milliseconds


public suspend fun S3Client.waitUntilBucketExists(request: HeadBucketRequest): Outcome<HeadBucketResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<HeadBucketRequest, HeadBucketResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { headBucket(request) }
}

public suspend fun S3Client.waitUntilBucketExists(block: HeadBucketRequest.Builder.() -> Unit): Outcome<HeadBucketResponse> =
    waitUntilBucketExists(HeadBucketRequest.Builder().apply(block).build())

public suspend fun S3Client.waitUntilBucketNotExists(request: HeadBucketRequest): Outcome<HeadBucketResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<HeadBucketRequest, HeadBucketResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { headBucket(request) }
}

public suspend fun S3Client.waitUntilBucketNotExists(block: HeadBucketRequest.Builder.() -> Unit): Outcome<HeadBucketResponse> =
    waitUntilBucketNotExists(HeadBucketRequest.Builder().apply(block).build())

public suspend fun S3Client.waitUntilObjectExists(request: HeadObjectRequest): Outcome<HeadObjectResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<HeadObjectRequest, HeadObjectResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { headObject(request) }
}

public suspend fun S3Client.waitUntilObjectExists(block: HeadObjectRequest.Builder.() -> Unit): Outcome<HeadObjectResponse> =
    waitUntilObjectExists(HeadObjectRequest.Builder().apply(block).build())

public suspend fun S3Client.waitUntilObjectNotExists(request: HeadObjectRequest): Outcome<HeadObjectResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<HeadObjectRequest, HeadObjectResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { headObject(request) }
}

public suspend fun S3Client.waitUntilObjectNotExists(block: HeadObjectRequest.Builder.() -> Unit): Outcome<HeadObjectResponse> =
    waitUntilObjectNotExists(HeadObjectRequest.Builder().apply(block).build())
