/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.financials.datatools.liquimongo.change;

import co.kuali.financials.datatools.liquimongo.change.AbstractDocumentStoreChangeHandler;
import co.kuali.financials.datatools.liquimongo.change.DocumentStoreChangeHandler;
import co.kuali.financials.datatools.liquimongo.change.QueryFromJson;
import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.MongoOperations;

public class UpdateDocumentHandler
extends AbstractDocumentStoreChangeHandler
implements DocumentStoreChangeHandler {
    private static final Logger LOG = Logger.getLogger(UpdateDocumentHandler.class);
    public static final String UPDATE_DOCUMENTS = "updateDocuments";
    private MongoOperations mongoTemplate;

    @Override
    public boolean handlesChange(JsonNode change) {
        return this.isKeyValueCorrect(change, "changeType", UPDATE_DOCUMENTS);
    }

    @Override
    public void makeChange(JsonNode change) {
        LOG.debug((Object)"makeChange() started");
        this.verifyKeyExistence(change, "collectionName");
        this.verifyKeyExistence(change, "query");
        this.verifyKeyExistence(change, "document");
        String collectionName = change.get("collectionName").asText();
        JsonNode query = change.get("query");
        JsonNode document = change.get("document");
        this.mongoTemplate.remove(QueryFromJson.get(query), collectionName);
        DBObject dbObject = (DBObject)JSON.parse((String)document.toString());
        this.mongoTemplate.save((Object)dbObject, collectionName);
    }

    public void setMongoTemplate(MongoOperations mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

