/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jdbc.JdbcConnectionProxyHelper;
import com.atomikos.jdbc.nonxa.AtomikosThreadLocalConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.DynamicProxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class AtomikosNonXAPooledConnection
extends AbstractXPooledConnection {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAPooledConnection.class);
    private Connection connection;
    private boolean erroneous;
    private boolean readOnly;
    private ConnectionPoolProperties props;

    public AtomikosNonXAPooledConnection(Connection wrapped, ConnectionPoolProperties props, boolean readOnly) {
        super(props);
        this.connection = wrapped;
        this.erroneous = false;
        this.readOnly = readOnly;
        this.props = props;
    }

    void setErroneous() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace((Object)((Object)this) + ": setErroneous");
        }
        this.erroneous = true;
    }

    public void destroy() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace((Object)((Object)this) + ": destroying...");
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.logWarning((Object)((Object)this) + ": Error closing JDBC connection: ", (Throwable)e);
        }
    }

    protected Reapable doCreateConnectionProxy() throws CreateConnectionException {
        Reapable ret = null;
        if (this.canBeRecycledForCallingThread()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": reusing existing proxy for thread...");
            }
            ret = this.getCurrentConnectionProxy();
            DynamicProxy dproxy = (DynamicProxy)ret;
            AtomikosThreadLocalConnection atomikosThreadLocalConnection = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": creating connection proxy...");
            }
            JdbcConnectionProxyHelper.setIsolationLevel(this.connection, this.getDefaultIsolationLevel());
            ret = (Reapable)AtomikosThreadLocalConnection.newInstance(this, this.props.getUniqueResourceName());
        }
        return ret;
    }

    Connection getConnection() {
        return this.connection;
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        String testQuery = this.getTestQuery();
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
        if (testQuery != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": testing connection with query [" + testQuery + "]");
            }
            Statement stmt = null;
            try {
                stmt = this.connection.createStatement();
                stmt.execute(testQuery);
                stmt.close();
            }
            catch (Exception e) {
                throw new CreateConnectionException("Error executing testQuery", e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": connection tested OK");
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace((Object)((Object)this) + ": no test query, skipping test");
        }
    }

    public boolean isAvailable() {
        boolean ret = true;
        Reapable handle = this.getCurrentConnectionProxy();
        if (handle != null) {
            DynamicProxy dproxy = (DynamicProxy)handle;
            AtomikosThreadLocalConnection previous = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
            ret = previous.isNoLongerInUse();
        }
        return ret;
    }

    public boolean isErroneous() {
        return this.erroneous;
    }

    protected void fireOnXPooledConnectionTerminated() {
        super.fireOnXPooledConnectionTerminated();
        this.updateLastTimeReleased();
    }

    public String toString() {
        return "AtomikosNonXAPooledConnection";
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean canBeRecycledForCallingThread() {
        boolean ret = false;
        Reapable handle = this.getCurrentConnectionProxy();
        if (handle != null) {
            CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
            CompositeTransaction ct = null;
            if (ctm != null) {
                ct = ctm.getCompositeTransaction();
            }
            if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
                DynamicProxy dproxy = (DynamicProxy)handle;
                AtomikosThreadLocalConnection previous = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
                ret = previous.isInTransaction(ct);
            }
        }
        return ret;
    }
}

