/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LazyParsedDependencyInfo;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompilerInput
extends DependencyInfo.Base
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private JSModule module;
    private final InputId id;
    private final SourceAst ast;
    private DependencyInfo dependencyInfo;
    private final List<DependencyInfo.Require> extraRequires = new ArrayList<DependencyInfo.Require>();
    private final List<String> extraProvides = new ArrayList<String>();
    private final List<DependencyInfo.Require> orderedRequires = new ArrayList<DependencyInfo.Require>();
    private final List<String> dynamicRequires = new ArrayList<String>();
    private boolean hasFullParseDependencyInfo = false;
    private ModuleType jsModuleType = ModuleType.NONE;
    private transient AbstractCompiler compiler;
    private transient ModuleLoader.ModulePath modulePath;

    public CompilerInput(SourceAst ast) {
        this(ast, ast.getSourceFile().getName(), false);
    }

    public CompilerInput(SourceAst ast, boolean isExtern) {
        this(ast, ast.getInputId(), isExtern);
    }

    public CompilerInput(SourceAst ast, String inputId, boolean isExtern) {
        this(ast, new InputId(inputId), isExtern);
    }

    public CompilerInput(SourceAst ast, InputId inputId, boolean isExtern) {
        this.ast = ast;
        this.id = inputId;
        if (ast != null && ast.getSourceFile() != null) {
            ast.getSourceFile().setIsExtern(isExtern);
        }
    }

    public CompilerInput(SourceFile file) {
        this(file, false);
    }

    public CompilerInput(SourceFile file, boolean isExtern) {
        this(new JsAst(file), isExtern);
    }

    @Override
    public InputId getInputId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id.getIdName();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        Node root = (Node)Preconditions.checkNotNull((Object)this.ast.getAstRoot(compiler));
        Preconditions.checkState((boolean)root.isScript());
        Preconditions.checkNotNull((Object)root.getInputId());
        return root;
    }

    @Override
    public void clearAst() {
        this.ast.clearAst();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.ast.getSourceFile();
    }

    @Override
    public void setSourceFile(SourceFile file) {
        this.ast.setSourceFile(file);
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public ImmutableList<DependencyInfo.Require> getRequires() {
        if (this.hasFullParseDependencyInfo) {
            return ImmutableList.copyOf(this.orderedRequires);
        }
        return this.getDependencyInfo().getRequires();
    }

    @Override
    public ImmutableList<String> getWeakRequires() {
        return this.getDependencyInfo().getWeakRequires();
    }

    ImmutableCollection<DependencyInfo.Require> getKnownRequires() {
        return CompilerInput.concat(this.dependencyInfo != null ? this.dependencyInfo.getRequires() : ImmutableList.of(), this.extraRequires);
    }

    ImmutableList<String> getKnownRequiredSymbols() {
        return DependencyInfo.Require.asSymbolList(this.getKnownRequires());
    }

    @Override
    public ImmutableList<String> getProvides() {
        return this.getDependencyInfo().getProvides();
    }

    ImmutableCollection<String> getKnownProvides() {
        return CompilerInput.concat(this.dependencyInfo != null ? this.dependencyInfo.getProvides() : ImmutableList.of(), this.extraProvides);
    }

    public void addProvide(String provide) {
        this.extraProvides.add(provide);
    }

    public boolean addOrderedRequire(DependencyInfo.Require require) {
        if (!this.orderedRequires.contains(require)) {
            this.orderedRequires.add(require);
            return true;
        }
        return false;
    }

    public ImmutableList<String> getDynamicRequires() {
        return ImmutableList.copyOf(this.dynamicRequires);
    }

    public boolean addDynamicRequire(String require) {
        if (!this.dynamicRequires.contains(require)) {
            this.dynamicRequires.add(require);
            return true;
        }
        return false;
    }

    public void setHasFullParseDependencyInfo(boolean hasFullParseDependencyInfo) {
        this.hasFullParseDependencyInfo = hasFullParseDependencyInfo;
    }

    public ModuleType getJsModuleType() {
        return this.jsModuleType;
    }

    public void setJsModuleType(ModuleType moduleType) {
        this.jsModuleType = moduleType;
    }

    public void addRequire(DependencyInfo.Require require) {
        this.extraRequires.add(require);
    }

    private DependencyInfo getDependencyInfo() {
        if (this.dependencyInfo == null) {
            this.dependencyInfo = this.generateDependencyInfo();
        }
        if (!this.extraRequires.isEmpty() || !this.extraProvides.isEmpty()) {
            this.dependencyInfo = SimpleDependencyInfo.builder(this.getName(), this.getName()).setProvides((Collection<String>)CompilerInput.concat(this.dependencyInfo.getProvides(), this.extraProvides)).setRequires((Collection<DependencyInfo.Require>)CompilerInput.concat(this.dependencyInfo.getRequires(), this.extraRequires)).setLoadFlags((Map<String, String>)this.dependencyInfo.getLoadFlags()).build();
            this.extraRequires.clear();
            this.extraProvides.clear();
        }
        return this.dependencyInfo;
    }

    private DependencyInfo generateDependencyInfo() {
        Preconditions.checkNotNull((Object)this.compiler, (String)"Expected setCompiler to be called first: %s", (Object)this);
        Preconditions.checkNotNull((Object)this.compiler.getErrorManager(), (String)"Expected compiler to call an error manager: %s", (Object)this);
        if (this.ast instanceof JsAst && JsFileParser.isSupported()) {
            try {
                DependencyInfo info = new JsFileParser(this.compiler.getErrorManager()).setIncludeGoogBase(true).parseFile(this.getName(), this.getName(), this.getCode());
                return new LazyParsedDependencyInfo(info, (JsAst)this.ast, this.compiler);
            }
            catch (IOException e) {
                this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName(), e.getMessage()));
                return SimpleDependencyInfo.EMPTY;
            }
        }
        DepsFinder finder = new DepsFinder(this.getPath());
        Node root = this.getAstRoot(this.compiler);
        if (root == null) {
            return SimpleDependencyInfo.EMPTY;
        }
        finder.visitTree(root);
        return SimpleDependencyInfo.builder("", "").setProvides(finder.provides).setRequires(finder.requires).setLoadFlags(finder.loadFlags).build();
    }

    public String getCode() throws IOException {
        return this.getSourceFile().getCode();
    }

    public JSModule getModule() {
        return this.module;
    }

    public void setModule(JSModule module) {
        Preconditions.checkArgument((module == null || this.module == null || this.module == module ? 1 : 0) != 0);
        this.module = module;
    }

    void overrideModule(JSModule module) {
        this.module = module;
    }

    public boolean isExtern() {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return false;
        }
        return this.ast.getSourceFile().isExtern();
    }

    void setIsExtern(boolean isExtern) {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return;
        }
        this.ast.getSourceFile().setIsExtern(isExtern);
    }

    public int getLineOffset(int lineno) {
        return this.ast.getSourceFile().getLineOffset(lineno);
    }

    public int getNumLines() {
        return this.ast.getSourceFile().getNumLines();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        return this.getDependencyInfo().getLoadFlags();
    }

    private static <T> ImmutableSet<T> concat(Iterable<T> first, Iterable<T> second) {
        return ImmutableSet.builder().addAll(first).addAll(second).build();
    }

    ModuleLoader.ModulePath getPath() {
        if (this.modulePath == null) {
            ModuleLoader moduleLoader = this.compiler.getModuleLoader();
            this.modulePath = moduleLoader.resolve(this.getName());
        }
        return this.modulePath;
    }

    public static enum ModuleType {
        NONE,
        GOOG,
        ES6,
        COMMONJS,
        JSON,
        IMPORTED_SCRIPT;

    }

    private static class DepsFinder {
        private final Map<String, String> loadFlags = new TreeMap<String, String>();
        private final List<String> provides = new ArrayList<String>();
        private final List<DependencyInfo.Require> requires = new ArrayList<DependencyInfo.Require>();
        private final ModuleLoader.ModulePath modulePath;

        DepsFinder(ModuleLoader.ModulePath modulePath) {
            this.modulePath = modulePath;
        }

        void visitTree(Node n) {
            String version;
            this.visitSubtree(n, null);
            Preconditions.checkArgument((boolean)n.isScript());
            FeatureSet features = (FeatureSet)n.getProp((byte)89);
            if (features != null && !(version = features.version()).equals("es3")) {
                this.loadFlags.put("lang", version);
            }
        }

        void visitSubtree(Node n, Node parent) {
            block0 : switch (n.getToken()) {
                case CALL: {
                    if (n.hasTwoChildren() && n.getFirstChild().isGetProp() && n.getFirstFirstChild().matchesQualifiedName("goog")) {
                        if (!this.requires.contains(DependencyInfo.Require.BASE)) {
                            this.requires.add(DependencyInfo.Require.BASE);
                        }
                        Node callee = n.getFirstChild();
                        Node argument = n.getLastChild();
                        switch (callee.getLastChild().getString()) {
                            case "module": {
                                this.loadFlags.put("module", "goog");
                            }
                            case "provide": {
                                if (!argument.isString()) {
                                    return;
                                }
                                this.provides.add(argument.getString());
                                return;
                            }
                            case "require": {
                                if (!argument.isString()) {
                                    return;
                                }
                                this.requires.add(DependencyInfo.Require.googRequireSymbol(argument.getString()));
                                return;
                            }
                            case "loadModule": {
                                n = argument.getLastChild();
                                break block0;
                            }
                        }
                        return;
                    }
                    if (!parent.isGetProp() || !parent.matchesQualifiedName("goog.module.declareNamespace") || !parent.getParent().isCall()) break;
                    Node argument = parent.getParent().getSecondChild();
                    if (!argument.isString()) {
                        return;
                    }
                    this.provides.add(argument.getString());
                    break;
                }
                case MODULE_BODY: {
                    if (parent.getBooleanProp((byte)87)) break;
                    this.provides.add(this.modulePath.toModuleName());
                    this.loadFlags.put("module", "es6");
                    break;
                }
                case IMPORT: {
                    this.visitEs6ModuleName(n.getLastChild(), n);
                    return;
                }
                case EXPORT: {
                    if (NodeUtil.isExportFrom(n)) {
                        this.visitEs6ModuleName(n.getLastChild(), n);
                    }
                    return;
                }
                case VAR: {
                    if (!n.getFirstChild().matchesQualifiedName("goog") || !NodeUtil.isNamespaceDecl(n.getFirstChild())) break;
                    this.provides.add("goog");
                    break;
                }
                case EXPR_RESULT: 
                case CONST: 
                case BLOCK: 
                case SCRIPT: 
                case NAME: 
                case DESTRUCTURING_LHS: 
                case LET: {
                    break;
                }
                default: {
                    return;
                }
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitSubtree(child, n);
            }
        }

        void visitEs6ModuleName(Node n, Node parent) {
            Preconditions.checkArgument((boolean)n.isString());
            Preconditions.checkArgument((parent.isExport() || parent.isImport() ? 1 : 0) != 0);
            String moduleName = n.getString();
            if (moduleName.startsWith("goog:")) {
                this.requires.add(DependencyInfo.Require.googRequireSymbol(moduleName.substring(5)));
                return;
            }
            ModuleLoader.ModulePath importedModule = this.modulePath.resolveJsModule(moduleName, this.modulePath.toString(), n.getLineno(), n.getCharno());
            if (importedModule == null) {
                importedModule = this.modulePath.resolveModuleAsPath(moduleName);
            }
            this.requires.add(DependencyInfo.Require.es6Import(importedModule.toModuleName(), n.getString()));
        }
    }
}

