/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import javax.annotation.Nullable;

final class DestructuredTarget {
    private final JSTypeRegistry registry;
    @Nullable
    private final Node objectPatternKey;
    private final Node node;
    private final Supplier<JSType> patternTypeSupplier;
    private final boolean isRest;

    private DestructuredTarget(Node node, @Nullable Node objectPatternKey, JSTypeRegistry registry, Supplier<JSType> patternTypeSupplier, boolean isRest) {
        this.node = node;
        this.objectPatternKey = objectPatternKey;
        this.registry = registry;
        this.patternTypeSupplier = patternTypeSupplier;
        this.isRest = isRest;
    }

    @Nullable
    Node getComputedProperty() {
        return this.hasComputedProperty() ? this.objectPatternKey.getFirstChild() : null;
    }

    boolean hasComputedProperty() {
        return this.objectPatternKey != null && this.objectPatternKey.isComputedProp();
    }

    public Node getNode() {
        return this.node;
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, JSType destructuringPatternType, Node destructuringChild) {
        return DestructuredTarget.createTarget(registry, (Supplier<JSType>)((Supplier)() -> destructuringPatternType), destructuringChild);
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, Supplier<JSType> destructuringPatternType, Node destructuringChild) {
        Node node;
        Preconditions.checkArgument((boolean)destructuringChild.getParent().isDestructuringPattern(), (Object)destructuringChild);
        Node objectLiteralKey = null;
        boolean isRest = false;
        switch (destructuringChild.getToken()) {
            case STRING_KEY: {
                objectLiteralKey = destructuringChild;
                Node value = destructuringChild.getFirstChild();
                node = value.isDefaultValue() ? value.getFirstChild() : value;
                break;
            }
            case COMPUTED_PROP: {
                objectLiteralKey = destructuringChild;
                Node value = destructuringChild.getSecondChild();
                node = value.isDefaultValue() ? value.getFirstChild() : value;
                break;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case NAME: 
            case GETELEM: 
            case GETPROP: {
                node = destructuringChild;
                break;
            }
            case DEFAULT_VALUE: {
                node = destructuringChild.getFirstChild();
                break;
            }
            case REST: {
                node = destructuringChild.getFirstChild();
                isRest = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected parameter node " + destructuringChild);
            }
        }
        return new DestructuredTarget(node, objectLiteralKey, registry, destructuringPatternType, isRest);
    }

    Supplier<JSType> getInferredTypeSupplier() {
        return () -> this.inferType();
    }

    JSType inferType() {
        if (this.objectPatternKey != null) {
            return this.inferObjectPatternKeyType();
        }
        return this.inferArrayPatternTargetType();
    }

    private JSType inferObjectPatternKeyType() {
        JSType patternType = (JSType)this.patternTypeSupplier.get();
        if (patternType == null || patternType.isUnknownType()) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        switch (this.objectPatternKey.getToken()) {
            case STRING_KEY: {
                JSType propertyType = patternType.findPropertyType(this.objectPatternKey.getString());
                return propertyType != null ? propertyType : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case COMPUTED_PROP: {
                return patternType != null ? patternType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getObjectElementKey()) : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
        }
        throw new IllegalStateException("Unexpected key " + this.objectPatternKey);
    }

    private JSType inferArrayPatternTargetType() {
        JSType patternType = (JSType)this.patternTypeSupplier.get();
        JSType templateTypeOfIterable = patternType.getInstantiatedTypeArgument(this.registry.getNativeType(JSTypeNative.ITERABLE_TYPE));
        if (this.isRest) {
            return this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), templateTypeOfIterable);
        }
        return templateTypeOfIterable;
    }
}

