/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedBytes;
import com.google.javascript.rhino.Node;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

@GwtIncompatible(value="com.google.common.primitives.UnsignedBytes")
class FileInstrumentationData {
    private final BitSet instrumentedBits;
    private final String arrayName;
    private final String fileName;
    private final BitSet branchPresent;
    private final Map<Integer, Integer> branchesInLine;
    private final Map<BranchIndexPair, Node> branchNodes;

    FileInstrumentationData(String fileName, String arrayName) {
        this.fileName = fileName;
        this.arrayName = arrayName;
        this.instrumentedBits = new BitSet();
        this.branchPresent = new BitSet();
        this.branchesInLine = new HashMap<Integer, Integer>();
        this.branchNodes = new HashMap<BranchIndexPair, Node>();
    }

    String getArrayName() {
        return this.arrayName;
    }

    String getFileName() {
        return this.fileName;
    }

    int maxInstrumentedLine() {
        return this.instrumentedBits.length();
    }

    int maxBranchPresentLine() {
        return this.branchPresent.length();
    }

    void putBranchNode(int lineNumber, int branchNumber, Node block) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as line number: %s", (int)lineNumber);
        Preconditions.checkArgument((branchNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as branch number: %s", (int)branchNumber);
        this.branchNodes.put(BranchIndexPair.of(lineNumber - 1, branchNumber - 1), block);
    }

    Node getBranchNode(int lineNumber, int branchNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as line number: %s", (int)lineNumber);
        Preconditions.checkArgument((branchNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as branch number: %s", (int)branchNumber);
        return this.branchNodes.get(BranchIndexPair.of(lineNumber - 1, branchNumber - 1));
    }

    private static String getHexString(BitSet bitSet) {
        StringBuilder builder = new StringBuilder();
        for (byte byteEntry : bitSet.toByteArray()) {
            int value = UnsignedBytes.toInt((byte)byteEntry);
            String hexString = Integer.toHexString(value);
            hexString = Strings.padStart((String)hexString, (int)2, (char)'0');
            builder.append(hexString);
        }
        return builder.toString();
    }

    String getInstrumentedLinesAsHexString() {
        return FileInstrumentationData.getHexString(this.instrumentedBits);
    }

    String getBranchPresentAsHexString() {
        return FileInstrumentationData.getHexString(this.branchPresent);
    }

    void setLineAsInstrumented(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as line number: %s", (int)lineNumber);
        this.instrumentedBits.set(lineNumber - 1);
    }

    void setBranchPresent(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (String)"Expected non-zero positive integer as line number: %s", (int)lineNumber);
        this.branchPresent.set(lineNumber - 1);
    }

    void addBranches(int lineNumber, int numberOfBranches) {
        int lineIdx = lineNumber - 1;
        Integer currentValue = this.branchesInLine.get(lineIdx);
        if (currentValue == null) {
            this.branchesInLine.put(lineIdx, numberOfBranches);
        } else {
            this.branchesInLine.put(lineIdx, currentValue + numberOfBranches);
        }
    }

    int getNumBranches(int lineNumber) {
        Integer numBranches = this.branchesInLine.get(lineNumber - 1);
        if (numBranches == null) {
            return 0;
        }
        return numBranches;
    }

    public static final class BranchIndexPair {
        private final int line;
        private final int branch;

        public int getLine() {
            return this.line;
        }

        public int getBranch() {
            return this.branch;
        }

        public BranchIndexPair(int line, int branch) {
            this.line = line;
            this.branch = branch;
        }

        public static BranchIndexPair of(int line, int branch) {
            return new BranchIndexPair(line, branch);
        }

        public int hashCode() {
            return 31 * this.line + this.branch;
        }

        public boolean equals(Object object) {
            if (object instanceof BranchIndexPair) {
                BranchIndexPair that = (BranchIndexPair)object;
                return this.getLine() == that.getLine() && this.getBranch() == that.getBranch();
            }
            return false;
        }
    }
}

