/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.TemplateType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class FunctionTypeBuilder {
    private final String fnName;
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final Node errorRoot;
    private final TypedScope enclosingScope;
    private FunctionContents contents = UnknownFunctionContents.get();
    private JSType returnType = null;
    private boolean returnTypeInferred = false;
    private List<ObjectType> implementedInterfaces = null;
    private List<ObjectType> extendedInterfaces = null;
    private ObjectType baseType = null;
    private JSType thisType = null;
    private boolean isClass = false;
    private boolean isConstructor = false;
    private boolean makesStructs = false;
    private boolean makesDicts = false;
    private boolean isInterface = false;
    private boolean isRecord = false;
    private boolean isAbstract = false;
    private Node parametersNode = null;
    private ImmutableList<TemplateType> templateTypeNames = ImmutableList.of();
    private ImmutableList<TemplateType> constructorTemplateTypeNames = ImmutableList.of();
    private TypedScope declarationScope = null;
    private StaticTypedScope templateScope;
    static final DiagnosticType EXTENDS_WITHOUT_TYPEDEF = DiagnosticType.warning("JSC_EXTENDS_WITHOUT_TYPEDEF", "@extends used without @constructor or @interface for {0}");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} @extends non-object type {1}");
    static final DiagnosticType RESOLVED_TAG_EMPTY = DiagnosticType.warning("JSC_RESOLVED_TAG_EMPTY", "Could not resolve type in {0} tag of {1}");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType CONSTRUCTOR_REQUIRED = DiagnosticType.warning("JSC_CONSTRUCTOR_REQUIRED", "{0} used without @constructor for {1}");
    static final DiagnosticType VAR_ARGS_MUST_BE_LAST = DiagnosticType.warning("JSC_VAR_ARGS_MUST_BE_LAST", "variable length argument must be last");
    static final DiagnosticType OPTIONAL_ARG_AT_END = DiagnosticType.warning("JSC_OPTIONAL_ARG_AT_END", "optional arguments must be at the end");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType TYPE_REDEFINITION = DiagnosticType.warning("JSC_TYPE_REDEFINITION", "attempted re-definition of type {0}\nfound   : {1}\nexpected: {2}");
    static final DiagnosticType TEMPLATE_TRANSFORMATION_ON_CLASS = DiagnosticType.warning("JSC_TEMPLATE_TRANSFORMATION_ON_CLASS", "Template type transformation {0} not allowed on classes or interfaces");
    static final DiagnosticType TEMPLATE_TYPE_DUPLICATED = DiagnosticType.warning("JSC_TEMPLATE_TYPE_DUPLICATED", "Only one parameter type must be the template type");
    static final DiagnosticType TEMPLATE_TYPE_EXPECTED = DiagnosticType.warning("JSC_TEMPLATE_TYPE_EXPECTED", "The template type must be a parameter type");
    static final DiagnosticType THIS_TYPE_NON_OBJECT = DiagnosticType.warning("JSC_THIS_TYPE_NON_OBJECT", "@this type of a function must be an object\nActual type: {0}");
    static final DiagnosticType SAME_INTERFACE_MULTIPLE_IMPLEMENTS = DiagnosticType.warning("JSC_SAME_INTERFACE_MULTIPLE_IMPLEMENTS", "Cannot @implement the same interface more than once\nRepeated interface: {0}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(EXTENDS_WITHOUT_TYPEDEF, EXTENDS_NON_OBJECT, RESOLVED_TAG_EMPTY, IMPLEMENTS_WITHOUT_CONSTRUCTOR, CONSTRUCTOR_REQUIRED, VAR_ARGS_MUST_BE_LAST, OPTIONAL_ARG_AT_END, INEXISTENT_PARAM, TYPE_REDEFINITION, TEMPLATE_TRANSFORMATION_ON_CLASS, TEMPLATE_TYPE_DUPLICATED, TEMPLATE_TYPE_EXPECTED, THIS_TYPE_NON_OBJECT, SAME_INTERFACE_MULTIPLE_IMPLEMENTS);

    FunctionTypeBuilder(String fnName, AbstractCompiler compiler, Node errorRoot, TypedScope scope) {
        Preconditions.checkNotNull((Object)errorRoot);
        this.fnName = Strings.nullToEmpty((String)fnName);
        this.codingConvention = compiler.getCodingConvention();
        this.typeRegistry = compiler.getTypeRegistry();
        this.errorRoot = errorRoot;
        this.compiler = compiler;
        this.enclosingScope = scope;
        this.templateScope = scope;
    }

    String formatFnName() {
        return this.fnName.isEmpty() ? "<anonymous>" : this.fnName;
    }

    FunctionTypeBuilder setContents(@Nullable FunctionContents contents) {
        if (contents != null) {
            this.contents = contents;
        }
        return this;
    }

    FunctionTypeBuilder setDeclarationScope(TypedScope declarationScope) {
        this.declarationScope = declarationScope;
        return this;
    }

    FunctionTypeBuilder inferFromOverriddenFunction(@Nullable FunctionType oldType, @Nullable Node paramsParent) {
        if (oldType == null) {
            return this;
        }
        this.templateTypeNames = oldType.getTemplateTypeMap().getTemplateKeys();
        this.returnType = oldType.getReturnType();
        this.returnTypeInferred = oldType.isReturnTypeInferred();
        if (paramsParent == null) {
            this.parametersNode = oldType.getParametersNode();
            if (this.parametersNode == null) {
                this.parametersNode = new FunctionParamBuilder(this.typeRegistry).build();
            }
        } else {
            FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.typeRegistry);
            Iterator<Node> oldParams = oldType.getParameters().iterator();
            boolean warnedAboutArgList = false;
            boolean oldParamsListHitOptArgs = false;
            for (Node currentParam = paramsParent.getFirstChild(); currentParam != null; currentParam = currentParam.getNext()) {
                if (oldParams.hasNext()) {
                    Node oldParam = oldParams.next();
                    Node newParam = paramBuilder.newParameterFromNode(oldParam);
                    boolean bl = oldParamsListHitOptArgs = oldParamsListHitOptArgs || oldParam.isVarArgs() || oldParam.isOptionalArg();
                    if (currentParam.getNext() == null || !newParam.isVarArgs()) continue;
                    newParam.setVarArgs(false);
                    newParam.setOptionalArg(true);
                    continue;
                }
                warnedAboutArgList |= this.addParameter(paramBuilder, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE), warnedAboutArgList, this.codingConvention.isOptionalParameter(currentParam) || oldParamsListHitOptArgs, this.codingConvention.isVarArgsParameter(currentParam));
            }
            while (oldParams.hasNext()) {
                paramBuilder.newOptionalParameterFromNode(oldParams.next());
            }
            this.parametersNode = paramBuilder.build();
        }
        return this;
    }

    FunctionTypeBuilder inferReturnType(@Nullable JSDocInfo info, boolean fromInlineDoc) {
        if (info != null) {
            JSTypeExpression returnTypeExpr;
            JSTypeExpression jSTypeExpression = returnTypeExpr = fromInlineDoc ? info.getType() : info.getReturnType();
            if (returnTypeExpr != null) {
                this.returnType = returnTypeExpr.evaluate(this.templateScope, this.typeRegistry);
                this.returnTypeInferred = false;
            }
        }
        return this;
    }

    FunctionTypeBuilder usingClassSyntax() {
        this.isClass = true;
        return this;
    }

    FunctionTypeBuilder inferKind(@Nullable JSDocInfo info) {
        if (info != null) {
            this.isConstructor = info.isConstructor();
            this.isInterface = info.isInterface();
            this.isRecord = info.usesImplicitMatch();
            this.isAbstract = info.isAbstract();
            this.makesStructs = info.makesStructs();
            this.makesDicts = info.makesDicts();
        }
        if (this.isClass) {
            this.isConstructor = !this.isInterface;
            boolean bl = this.makesStructs = info == null || !this.makesDicts && !info.makesUnrestricted();
        }
        if (this.makesStructs && !this.isConstructor && !this.isInterface) {
            this.reportWarning(CONSTRUCTOR_REQUIRED, "@struct", this.formatFnName());
        } else if (this.makesDicts && !this.isConstructor) {
            this.reportWarning(CONSTRUCTOR_REQUIRED, "@dict", this.formatFnName());
        }
        return this;
    }

    private boolean maybeUseNativeClassTemplateNames(JSDocInfo info) {
        ImmutableList<TemplateType> nativeKeys = this.typeRegistry.maybeGetTemplateTypesOfBuiltin(this.fnName);
        if (nativeKeys != null && info.getTemplateTypeNames().size() == nativeKeys.size()) {
            this.templateTypeNames = nativeKeys;
            return true;
        }
        return false;
    }

    FunctionTypeBuilder inferInheritance(@Nullable JSDocInfo info, @Nullable ObjectType baseType) {
        if (info != null && info.hasBaseType()) {
            if (this.isConstructor) {
                ObjectType infoBaseType;
                baseType = infoBaseType = info.getBaseType().evaluate(this.templateScope, this.typeRegistry).toMaybeObjectType();
            } else {
                this.reportWarning(EXTENDS_WITHOUT_TYPEDEF, this.formatFnName());
            }
        }
        if (baseType != null && this.isConstructor && baseType.setValidator(new ExtendedTypeValidator())) {
            this.baseType = baseType;
        }
        if (info != null && info.getImplementedInterfaceCount() > 0) {
            if (this.isConstructor) {
                this.implementedInterfaces = new ArrayList<ObjectType>();
                HashSet<JSType> baseInterfaces = new HashSet<JSType>();
                for (JSTypeExpression t : info.getImplementedInterfaces()) {
                    JSType maybeInterType = t.evaluate(this.templateScope, this.typeRegistry);
                    if (maybeInterType == null || !maybeInterType.setValidator(new ImplementedTypeValidator())) continue;
                    JSType baseInterface = maybeInterType;
                    if (baseInterface.toMaybeTemplatizedType() != null) {
                        baseInterface = baseInterface.toMaybeTemplatizedType().getReferencedType();
                    }
                    if (!baseInterfaces.add(baseInterface)) {
                        this.reportWarning(SAME_INTERFACE_MULTIPLE_IMPLEMENTS, baseInterface.toString());
                    }
                    this.implementedInterfaces.add((ObjectType)maybeInterType);
                }
            } else if (this.isInterface) {
                this.reportWarning(TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, this.formatFnName());
            } else {
                this.reportWarning(CONSTRUCTOR_REQUIRED, "@implements", this.formatFnName());
            }
        }
        if (this.isInterface) {
            this.extendedInterfaces = new ArrayList<ObjectType>();
            if (info != null) {
                for (JSTypeExpression t : info.getExtendedInterfaces()) {
                    JSType maybeInterfaceType = t.evaluate(this.templateScope, this.typeRegistry);
                    if (maybeInterfaceType != null && maybeInterfaceType.setValidator(new ExtendedTypeValidator())) {
                        this.extendedInterfaces.add((ObjectType)maybeInterfaceType);
                    }
                    if (baseType == null || !maybeInterfaceType.isSubtypeOf(baseType)) continue;
                    baseType = null;
                }
            }
            if (baseType != null && baseType.setValidator(new ExtendedTypeValidator())) {
                this.extendedInterfaces.add(baseType);
            }
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo info, JSType type) {
        ObjectType objType;
        this.inferThisType(info);
        if (!(this.thisType != null || (objType = ObjectType.cast(type)) == null || info != null && info.hasType())) {
            this.thisType = objType;
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo info) {
        JSType maybeThisType;
        if (info != null && info.hasThisType() && (maybeThisType = info.getThisType().evaluate(this.templateScope, this.typeRegistry).restrictByNotNullOrUndefined()) != null) {
            this.thisType = maybeThisType;
        }
        return this;
    }

    FunctionTypeBuilder inferParameterTypes(JSDocInfo info) {
        Node lp = IR.paramList();
        for (String name : info.getParameterNames()) {
            lp.addChildToBack(IR.name(name));
        }
        return this.inferParameterTypes(lp, info);
    }

    FunctionTypeBuilder inferParameterTypes(@Nullable Node paramsParent, @Nullable JSDocInfo info) {
        if (paramsParent == null) {
            if (info == null) {
                return this;
            }
            return this.inferParameterTypes(info);
        }
        Node oldParameterType = null;
        if (this.parametersNode != null) {
            oldParameterType = this.parametersNode.getFirstChild();
        }
        FunctionParamBuilder builder = new FunctionParamBuilder(this.typeRegistry);
        boolean warnedAboutArgList = false;
        HashSet allJsDocParams = info == null ? new HashSet() : new HashSet<String>(info.getParameterNames());
        boolean isVarArgs = false;
        int paramIndex = 0;
        for (Node param : paramsParent.children()) {
            boolean isOptionalParam = false;
            if (param.isDefaultValue()) {
                param = (Node)Preconditions.checkNotNull((Object)param.getFirstChild(), (Object)param);
            }
            if (param.isRest()) {
                isVarArgs = true;
                param = param.getOnlyChild();
            } else {
                isVarArgs = this.isVarArgsParameter(param, info);
                isOptionalParam = this.isOptionalParameter(param, info);
            }
            String paramName = null;
            if (param.isName()) {
                paramName = param.getString();
            } else {
                Preconditions.checkState((boolean)param.isDestructuringPattern());
                if (info != null) {
                    paramName = info.getParameterNameAt(paramIndex);
                }
            }
            allJsDocParams.remove(paramName);
            JSType parameterType = null;
            if (info != null && info.hasParameterType(paramName)) {
                parameterType = info.getParameterType(paramName).evaluate(this.templateScope, this.typeRegistry);
            } else if (param.getJSDocInfo() != null && param.getJSDocInfo().hasType()) {
                JSTypeExpression parameterTypeExpression = param.getJSDocInfo().getType();
                parameterType = parameterTypeExpression.evaluate(this.templateScope, this.typeRegistry);
                isOptionalParam = parameterTypeExpression.isOptionalArg();
                isVarArgs = parameterTypeExpression.isVarArgs();
            } else if (oldParameterType != null && oldParameterType.getJSType() != null) {
                parameterType = oldParameterType.getJSType();
                isOptionalParam = oldParameterType.isOptionalArg();
                isVarArgs = oldParameterType.isVarArgs();
            } else {
                parameterType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            warnedAboutArgList |= this.addParameter(builder, parameterType, warnedAboutArgList, isOptionalParam, isVarArgs);
            if (oldParameterType != null) {
                oldParameterType = oldParameterType.getNext();
            }
            ++paramIndex;
        }
        if (!isVarArgs) {
            while (oldParameterType != null && !isVarArgs) {
                builder.newParameterFromNode(oldParameterType);
                oldParameterType = oldParameterType.getNext();
            }
        }
        for (String inexistentName : allJsDocParams) {
            this.reportWarning(INEXISTENT_PARAM, inexistentName, this.formatFnName());
        }
        this.parametersNode = builder.build();
        return this;
    }

    private void registerTemplates(Iterable<TemplateType> templates, @Nullable Node scopeRoot) {
        if (!Iterables.isEmpty(templates)) {
            this.templateScope = this.typeRegistry.createScopeWithTemplates(this.templateScope, templates);
            if (scopeRoot != null) {
                this.typeRegistry.registerTemplateTypeNamesInScope(templates, scopeRoot);
            }
        }
    }

    FunctionTypeBuilder inferConstructorParameters(Node argsParent, @Nullable JSDocInfo info) {
        if (info != null) {
            this.setConstructorTemplateTypeNames((List<TemplateType>)this.buildTemplateTypesFromJSDocInfo(info, true), argsParent.getParent());
        }
        this.inferParameterTypes(argsParent, info);
        return this;
    }

    FunctionTypeBuilder inferConstructorParameters(FunctionType superCtor) {
        this.inferImplicitConstructorParameters(superCtor.getParametersNode().cloneTree());
        this.setConstructorTemplateTypeNames((List<TemplateType>)superCtor.getConstructorOnlyTemplateParameters(), null);
        return this;
    }

    FunctionTypeBuilder inferImplicitConstructorParameters(Node parametersNode) {
        this.parametersNode = parametersNode;
        return this;
    }

    private void setConstructorTemplateTypeNames(List<TemplateType> templates, @Nullable Node ctor) {
        if (!templates.isEmpty()) {
            this.constructorTemplateTypeNames = ImmutableList.copyOf(templates);
            this.templateTypeNames = this.templateTypeNames.isEmpty() ? ImmutableList.copyOf(templates) : ImmutableList.builder().addAll(this.templateTypeNames).addAll(this.constructorTemplateTypeNames).build();
            this.registerTemplates(templates, ctor);
        }
    }

    private boolean isOptionalParameter(Node param, @Nullable JSDocInfo info) {
        if (param.isDestructuringPattern()) {
            return false;
        }
        if (this.codingConvention.isOptionalParameter(param)) {
            return true;
        }
        String paramName = param.getString();
        return info != null && info.hasParameterType(paramName) && info.getParameterType(paramName).isOptionalArg();
    }

    private boolean isVarArgsParameter(Node param, @Nullable JSDocInfo info) {
        if (param.isDestructuringPattern()) {
            return false;
        }
        if (this.codingConvention.isVarArgsParameter(param)) {
            return true;
        }
        String paramName = param.getString();
        return info != null && info.hasParameterType(paramName) && info.getParameterType(paramName).isVarArgs();
    }

    private ImmutableList<TemplateType> buildTemplateTypesFromJSDocInfo(JSDocInfo info, boolean allowTypeTransformations) {
        ImmutableList<String> infoTypeKeys = info.getTemplateTypeNames();
        ImmutableMap<String, Node> infoTypeTransformations = info.getTypeTransformations();
        if (infoTypeKeys.isEmpty() && infoTypeTransformations.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder templates = ImmutableList.builder();
        for (String key : infoTypeKeys) {
            templates.add((Object)this.typeRegistry.createTemplateType(key));
        }
        for (String key : infoTypeTransformations.keySet()) {
            if (allowTypeTransformations) {
                templates.add((Object)this.typeRegistry.createTemplateTypeWithTransformation(key, (Node)infoTypeTransformations.get((Object)key)));
                continue;
            }
            this.reportWarning(TEMPLATE_TRANSFORMATION_ON_CLASS, key);
        }
        return templates.build();
    }

    FunctionTypeBuilder inferTemplateTypeName(@Nullable JSDocInfo info, @Nullable JSType ownerType) {
        ImmutableList<TemplateType> ownerTypeKeys;
        ImmutableList<TemplateType> templates;
        if (info != null && !this.maybeUseNativeClassTemplateNames(info) && !(templates = this.buildTemplateTypesFromJSDocInfo(info, !this.isConstructor && !this.isInterface)).isEmpty()) {
            this.templateTypeNames = templates;
        }
        ImmutableList<TemplateType> immutableList = ownerTypeKeys = ownerType != null ? ownerType.getTemplateTypeMap().getTemplateKeys() : ImmutableList.of();
        if (!this.templateTypeNames.isEmpty() || !ownerTypeKeys.isEmpty()) {
            this.registerTemplates(Iterables.concat(this.templateTypeNames, ownerTypeKeys), this.contents.getSourceNode());
        }
        return this;
    }

    private boolean addParameter(FunctionParamBuilder builder, JSType paramType, boolean warnedAboutArgList, boolean isOptional, boolean isVarArgs) {
        boolean emittedWarning = false;
        if (isOptional) {
            if (!builder.addOptionalParams(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (isVarArgs) {
            if (!builder.addVarArgs(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (!builder.addRequiredParams(paramType) && !warnedAboutArgList) {
            if (builder.hasVarArgs()) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
            } else {
                this.reportWarning(OPTIONAL_ARG_AT_END, new String[0]);
            }
            emittedWarning = true;
        }
        return emittedWarning;
    }

    private void provideDefaultReturnType() {
        if (this.contents.getSourceNode() != null && this.contents.getSourceNode().isGeneratorFunction()) {
            ObjectType generatorType = this.typeRegistry.getNativeObjectType(JSTypeNative.GENERATOR_TYPE);
            this.returnType = this.typeRegistry.createTemplatizedType(generatorType, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            return;
        }
        JSType inferredReturnType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (!(this.contents.mayHaveNonEmptyReturns() || this.contents.mayHaveSingleThrow() || this.contents.mayBeFromExterns())) {
            inferredReturnType = this.typeRegistry.getNativeType(JSTypeNative.VOID_TYPE);
            this.returnTypeInferred = true;
        }
        if (this.contents.getSourceNode() != null && this.contents.getSourceNode().isAsyncFunction()) {
            ObjectType promiseType = this.typeRegistry.getNativeObjectType(JSTypeNative.PROMISE_TYPE);
            this.returnType = this.typeRegistry.createTemplatizedType(promiseType, inferredReturnType);
        } else {
            this.returnType = inferredReturnType;
        }
    }

    FunctionType buildAndRegister() {
        FunctionType fnType;
        if (this.returnType == null) {
            this.provideDefaultReturnType();
            Preconditions.checkNotNull((Object)this.returnType);
        }
        if (this.parametersNode == null) {
            throw new IllegalStateException("All Function types must have params and a return type");
        }
        if (this.isConstructor) {
            fnType = this.getOrCreateConstructor();
        } else if (this.isInterface) {
            fnType = this.getOrCreateInterface();
        } else {
            fnType = new FunctionBuilder(this.typeRegistry).withName(this.fnName).withSourceNode(this.contents.getSourceNode()).withParamsNode(this.parametersNode).withReturnType(this.returnType, this.returnTypeInferred).withTypeOfThis(this.thisType).withTemplateKeys(this.templateTypeNames).withIsAbstract(this.isAbstract).build();
            this.maybeSetBaseType(fnType);
        }
        if (this.implementedInterfaces != null && fnType.isConstructor()) {
            fnType.setImplementedInterfaces(this.implementedInterfaces);
        }
        if (this.extendedInterfaces != null) {
            fnType.setExtendedInterfaces(this.extendedInterfaces);
        }
        if (this.isRecord) {
            fnType.setImplicitMatch(true);
        }
        return fnType;
    }

    private void maybeSetBaseType(FunctionType fnType) {
        if (!fnType.isInterface() && this.baseType != null) {
            fnType.setPrototypeBasedOn(this.baseType);
            fnType.extendTemplateTypeMapBasedOn(this.baseType);
        }
    }

    private FunctionType getOrCreateConstructor() {
        boolean isInstanceObject;
        FunctionType fnType = new FunctionBuilder(this.typeRegistry).forConstructor().withName(this.fnName).withSourceNode(this.contents.getSourceNode()).withParamsNode(this.parametersNode).withReturnType(this.returnType).withTemplateKeys(this.templateTypeNames).withConstructorTemplateKeys((Iterable<TemplateType>)this.constructorTemplateTypeNames).withIsAbstract(this.isAbstract).build();
        if (this.makesStructs) {
            fnType.setStruct();
        } else if (this.makesDicts) {
            fnType.setDict();
        }
        JSType existingType = this.typeRegistry.getTypeForScope(this.getScopeDeclaredIn(), this.fnName);
        if (existingType != null && ((isInstanceObject = existingType.isInstanceType()) || this.fnName.equals("Function"))) {
            FunctionType existingFn;
            FunctionType functionType = existingFn = isInstanceObject ? existingType.toObjectType().getConstructor() : this.typeRegistry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            if (existingFn.getSource() == null) {
                existingFn.setSource(this.contents.getSourceNode());
            }
            if (!existingFn.hasEqualCallType(fnType)) {
                this.reportWarning(TYPE_REDEFINITION, this.formatFnName(), fnType.toString(), existingFn.toString());
            }
            if (existingFn.isNativeObjectType()) {
                this.maybeSetBaseType(existingFn);
            }
            return existingFn;
        }
        this.maybeSetBaseType(fnType);
        if (!this.fnName.isEmpty() && !this.fnName.startsWith("this.")) {
            this.typeRegistry.declareTypeForExactScope(this.getScopeDeclaredIn(), this.fnName, fnType.getInstanceType());
        }
        return fnType;
    }

    private FunctionType getOrCreateInterface() {
        FunctionType ctor;
        FunctionType fnType = null;
        JSType type = this.typeRegistry.getType(this.getScopeDeclaredIn(), this.fnName);
        if (type != null && type.isInstanceType() && (ctor = type.toMaybeObjectType().getConstructor()).isInterface()) {
            fnType = ctor;
            fnType.setSource(this.contents.getSourceNode());
        }
        if (fnType == null) {
            fnType = this.typeRegistry.createInterfaceType(this.fnName, this.contents.getSourceNode(), this.templateTypeNames, this.makesStructs);
            if (!this.fnName.isEmpty()) {
                this.typeRegistry.declareTypeForExactScope(this.getScopeDeclaredIn(), this.fnName, fnType.getInstanceType());
            }
            this.maybeSetBaseType(fnType);
        }
        return fnType;
    }

    private void reportWarning(DiagnosticType warning, String ... args) {
        this.compiler.report(JSError.make(this.errorRoot, warning, args));
    }

    private void reportError(DiagnosticType error, String ... args) {
        this.compiler.report(JSError.make(this.errorRoot, error, args));
    }

    static boolean isFunctionTypeDeclaration(JSDocInfo info) {
        return info.getParameterCount() > 0 || info.hasReturnType() || info.hasThisType() || info.isConstructor() || info.isInterface() || info.isAbstract();
    }

    private TypedScope getScopeDeclaredIn() {
        String rootVarName;
        TypedVar rootVar;
        if (this.declarationScope != null) {
            return this.declarationScope;
        }
        int dotIndex = this.fnName.indexOf(46);
        if (dotIndex != -1 && (rootVar = (TypedVar)this.enclosingScope.getVar(rootVarName = this.fnName.substring(0, dotIndex))) != null) {
            return (TypedScope)rootVar.getScope();
        }
        return this.enclosingScope;
    }

    private static boolean hasMoreTagsToResolve(ObjectType objectType) {
        Preconditions.checkArgument((boolean)objectType.isUnknownType());
        FunctionType ctor = objectType.getConstructor();
        if (ctor != null) {
            for (ObjectType interfaceType : ctor.getExtendedInterfaces()) {
                if (interfaceType.isResolved()) continue;
                return true;
            }
        }
        if (objectType.getImplicitPrototype() != null) {
            return !objectType.getImplicitPrototype().isResolved();
        }
        return false;
    }

    static class AstFunctionContents
    implements FunctionContents {
        private final Node n;
        private boolean hasNonEmptyReturns = false;

        AstFunctionContents(Node n) {
            this.n = n;
        }

        @Override
        public Node getSourceNode() {
            return this.n;
        }

        @Override
        public boolean mayBeFromExterns() {
            return this.n.isFromExterns();
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return this.hasNonEmptyReturns;
        }

        void recordNonEmptyReturn() {
            this.hasNonEmptyReturns = true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            Node block = this.n.getLastChild();
            return block.hasOneChild() && block.getFirstChild().isThrow();
        }
    }

    static class UnknownFunctionContents
    implements FunctionContents {
        private static final UnknownFunctionContents singleton = new UnknownFunctionContents();

        UnknownFunctionContents() {
        }

        static FunctionContents get() {
            return singleton;
        }

        @Override
        public Node getSourceNode() {
            return null;
        }

        @Override
        public boolean mayBeFromExterns() {
            return true;
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            return true;
        }
    }

    static interface FunctionContents {
        public Node getSourceNode();

        public boolean mayBeFromExterns();

        public boolean mayHaveNonEmptyReturns();

        public boolean mayHaveSingleThrow();
    }

    private class ImplementedTypeValidator
    implements Predicate<JSType> {
        private ImplementedTypeValidator() {
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportError(TypeCheck.BAD_IMPLEMENTED_TYPE, new String[]{FunctionTypeBuilder.this.fnName});
                return false;
            }
            if (objectType.isEmptyType()) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@implements", FunctionTypeBuilder.this.fnName});
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType)) {
                    return true;
                }
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@implements", FunctionTypeBuilder.this.fnName});
                return false;
            }
            return true;
        }
    }

    private class ExtendedTypeValidator
    implements Predicate<JSType> {
        private ExtendedTypeValidator() {
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportWarning(EXTENDS_NON_OBJECT, new String[]{FunctionTypeBuilder.this.formatFnName(), type.toString()});
                return false;
            }
            if (objectType.isEmptyType()) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@extends", FunctionTypeBuilder.this.formatFnName()});
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType) || type.isTemplateType()) {
                    return true;
                }
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@extends", FunctionTypeBuilder.this.fnName});
                return false;
            }
            return true;
        }
    }
}

