/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class GlobalNamespace
implements StaticTypedScope,
StaticSymbolTable<Name, Ref> {
    private final AbstractCompiler compiler;
    private final Node root;
    private final Node externsRoot;
    private SourceKind sourceKind;
    private Scope externsScope;
    private boolean generated = false;
    private int currentPreOrderIndex = 0;
    private final List<Name> globalNames = new ArrayList<Name>();
    private final Map<String, Name> nameMap = new HashMap<String, Name>();

    GlobalNamespace(AbstractCompiler compiler, Node root) {
        this(compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node externsRoot, Node root) {
        this.compiler = compiler;
        this.externsRoot = externsRoot;
        this.root = root;
    }

    boolean hasExternsRoot() {
        return this.externsRoot != null;
    }

    @Override
    public Node getRootNode() {
        return this.root.getParent();
    }

    @Override
    public StaticTypedScope getParentScope() {
        return null;
    }

    @Override
    public Name getSlot(String name) {
        return this.getOwnSlot(name);
    }

    @Override
    public Name getOwnSlot(String name) {
        this.ensureGenerated();
        return this.nameMap.get(name);
    }

    @Override
    public JSType getTypeOfThis() {
        return this.compiler.getTypeRegistry().getNativeObjectType(JSTypeNative.GLOBAL_THIS);
    }

    @Override
    public Iterable<Ref> getReferences(Name slot) {
        this.ensureGenerated();
        return Collections.unmodifiableList(slot.getRefs());
    }

    public StaticTypedScope getScope(Name slot) {
        return this;
    }

    @Override
    public Iterable<Name> getAllSymbols() {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(this.getNameIndex().values());
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.process();
        }
    }

    List<Name> getNameForest() {
        this.ensureGenerated();
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        this.ensureGenerated();
        return this.nameMap;
    }

    void scanNewNodes(Set<AstChange> newNodes) {
        BuildGlobalNamespace builder = new BuildGlobalNamespace();
        for (AstChange info : newNodes) {
            if (!info.node.isQualifiedName() && !NodeUtil.isObjectLitKey(info.node)) continue;
            this.scanFromNode(builder, info.module, info.scope, info.node);
        }
    }

    private void scanFromNode(BuildGlobalNamespace builder, JSModule module, Scope scope, Node n) {
        if (n.isName() || n.isGetProp()) {
            this.scanFromNode(builder, module, scope, n.getParent());
        }
        builder.collect(module, scope, n);
    }

    private void process() {
        if (this.hasExternsRoot()) {
            this.sourceKind = SourceKind.EXTERN;
            NodeTraversal.traverse(this.compiler, this.externsRoot, new BuildGlobalNamespace());
        }
        this.sourceKind = SourceKind.CODE;
        NodeTraversal.traverse(this.compiler, this.root, new BuildGlobalNamespace());
        this.generated = true;
        this.externsScope = null;
    }

    private boolean isGlobalNameReference(String name, Scope s) {
        String topVarName = GlobalNamespace.getTopVarName(name);
        return this.isGlobalVarReference(topVarName, s);
    }

    private static String getTopVarName(String name) {
        int firstDotIndex = name.indexOf(46);
        return firstDotIndex == -1 ? name : name.substring(0, firstDotIndex);
    }

    private boolean isGlobalVarReference(String name, Scope s) {
        Var v = (Var)s.getVar(name);
        if (v == null && this.externsScope != null) {
            v = (Var)this.externsScope.getVar(name);
        }
        return v != null && !v.isLocal();
    }

    static class Ref
    implements StaticTypedRef {
        Node node;
        final JSModule module;
        final Name name;
        final Type type;
        final Scope scope;
        final int preOrderIndex;
        private Ref twin = null;

        Ref(JSModule module, Scope scope, Node node, Name name, Type type, int index) {
            this.node = node;
            this.name = name;
            this.module = module;
            this.type = type;
            this.scope = scope;
            this.preOrderIndex = index;
        }

        private Ref(Ref original, Type type, int index) {
            this.node = original.node;
            this.name = original.name;
            this.module = original.module;
            this.type = type;
            this.scope = original.scope;
            this.preOrderIndex = index;
        }

        private Ref(Type type, int index) {
            this.type = type;
            this.module = null;
            this.scope = null;
            this.name = null;
            this.preOrderIndex = index;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.node != null ? this.node.getStaticSourceFile() : null;
        }

        @Override
        public StaticTypedSlot getSymbol() {
            return this.name;
        }

        JSModule getModule() {
            return this.module;
        }

        Ref getTwin() {
            return this.twin;
        }

        boolean isSet() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.SET_FROM_LOCAL;
        }

        static void markTwins(Ref a, Ref b) {
            Preconditions.checkArgument((!(a.type != Type.ALIASING_GET && b.type != Type.ALIASING_GET || a.type != Type.SET_FROM_GLOBAL && a.type != Type.SET_FROM_LOCAL && b.type != Type.SET_FROM_GLOBAL && b.type != Type.SET_FROM_LOCAL) ? 1 : 0) != 0);
            a.twin = b;
            b.twin = a;
        }

        Ref cloneAndReclassify(Type type) {
            return new Ref(this, type, this.preOrderIndex);
        }

        static Ref createRefForTesting(Type type) {
            return new Ref(type, -1);
        }

        public String toString() {
            return this.node.toString();
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET,
            DELETE_PROP;

        }
    }

    static class Name
    implements StaticTypedSlot {
        private final String baseName;
        final Name parent;
        @Nullable
        List<Name> props;
        private Ref declaration;
        private List<Ref> refs;
        @Nullable
        List<Name> subclasses;
        Type type;
        private boolean declaredType = false;
        private boolean isDeclared = false;
        private boolean isModuleProp = false;
        private boolean usedHasOwnProperty = false;
        int globalSets = 0;
        int localSets = 0;
        int localSetsWithNoCollapse = 0;
        int aliasingGets = 0;
        int totalGets = 0;
        int callGets = 0;
        int deleteProps = 0;
        private final SourceKind sourceKind;
        JSDocInfo docInfo = null;

        static Name createForTesting(String name) {
            return new Name(name, null, SourceKind.CODE);
        }

        private Name(String name, Name parent, SourceKind sourceKind) {
            this.baseName = name;
            this.parent = parent;
            this.type = Type.OTHER;
            this.sourceKind = sourceKind;
        }

        Name addProperty(String name, SourceKind sourceKind, boolean shouldCreateProp) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name node = new Name(name, this, sourceKind);
            if (shouldCreateProp) {
                this.props.add(node);
            }
            return node;
        }

        Name addSubclass(Name subclassName) {
            Preconditions.checkArgument((this.type == Type.CLASS && subclassName.type == Type.CLASS ? 1 : 0) != 0);
            if (this.subclasses == null) {
                this.subclasses = new ArrayList<Name>();
            }
            this.subclasses.add(subclassName);
            return subclassName;
        }

        String getBaseName() {
            return this.baseName;
        }

        boolean inExterns() {
            return this.sourceKind == SourceKind.EXTERN;
        }

        SourceKind getSourceKind() {
            return this.sourceKind;
        }

        @Override
        public String getName() {
            return this.getFullName();
        }

        String getFullName() {
            return this.parent == null ? this.baseName : this.parent.getFullName() + '.' + this.baseName;
        }

        @Override
        public Ref getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean isTypeInferred() {
            return false;
        }

        @Override
        public JSType getType() {
            return null;
        }

        @Override
        public StaticTypedScope getScope() {
            throw new UnsupportedOperationException();
        }

        void addRef(Ref ref) {
            this.addRefInternal(ref);
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                        this.docInfo = Name.getDocInfoForDeclaration(ref);
                    }
                    ++this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    ++this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info == null || !info.isNoCollapse()) break;
                    ++this.localSetsWithNoCollapse;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    Node node = ref.getNode();
                    if (node != null && node.isGetProp() && node.getParent().isExprResult()) {
                        this.docInfo = node.getJSDocInfo();
                    }
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    ++this.deleteProps;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        void removeRef(Ref ref) {
            if (this.refs != null && this.refs.remove(ref)) {
                if (ref == this.declaration) {
                    this.declaration = null;
                    if (this.refs != null) {
                        for (Ref maybeNewDecl : this.refs) {
                            if (maybeNewDecl.type != Ref.Type.SET_FROM_GLOBAL) continue;
                            this.declaration = maybeNewDecl;
                            break;
                        }
                    }
                }
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        --this.globalSets;
                        break;
                    }
                    case SET_FROM_LOCAL: {
                        JSDocInfo info;
                        --this.localSets;
                        JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                        if (info == null || !info.isNoCollapse()) break;
                        --this.localSetsWithNoCollapse;
                        break;
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: {
                        --this.totalGets;
                        break;
                    }
                    case ALIASING_GET: {
                        --this.aliasingGets;
                        --this.totalGets;
                        break;
                    }
                    case CALL_GET: {
                        --this.callGets;
                        --this.totalGets;
                        break;
                    }
                    case DELETE_PROP: {
                        --this.deleteProps;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        List<Ref> getRefs() {
            return this.refs == null ? ImmutableList.of() : this.refs;
        }

        void addRefInternal(Ref ref) {
            if (this.refs == null) {
                this.refs = new ArrayList<Ref>();
            }
            this.refs.add(ref);
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name n : this.props) {
                    if (n.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isSimpleStubDeclaration() {
            if (this.getRefs().size() == 1) {
                Ref ref = this.refs.get(0);
                if (ref.node.getParent().isExprResult()) {
                    return true;
                }
            }
            return false;
        }

        boolean isCollapsingExplicitlyDenied() {
            Ref ref;
            if (this.docInfo == null && (ref = this.getDeclaration()) != null) {
                this.docInfo = Name.getDocInfoForDeclaration(ref);
            }
            return this.docInfo != null && this.docInfo.isNoCollapse();
        }

        boolean isInlinableGlobalAlias() {
            if (this.inExterns() || this.globalSets != 1 || this.localSets != 0 || !this.canCollapse()) {
                return false;
            }
            block6: for (Ref ref : this.getRefs()) {
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        continue block6;
                    }
                    case SET_FROM_LOCAL: {
                        throw new IllegalStateException();
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: 
                    case ALIASING_GET: 
                    case CALL_GET: {
                        continue block6;
                    }
                    case DELETE_PROP: {
                        return false;
                    }
                }
                throw new IllegalStateException();
            }
            return true;
        }

        boolean canCollapse() {
            return !(this.inExterns() || this.isGetOrSetDefinition() || this.isCollapsingExplicitlyDenied() || !this.declaredType && (this.parent != null && !this.parent.canCollapseUnannotatedChildNames() || this.globalSets <= 0 && this.localSets <= 0 || this.localSetsWithNoCollapse != 0 || this.deleteProps != 0) || this.isStaticClassMemberFunction());
        }

        boolean isStaticClassMemberFunction() {
            Node n;
            Ref ref = this.getDeclaration();
            return ref != null && (n = ref.getNode()) != null && n.isStaticMember() && n.getParent().isClassMembers();
        }

        boolean isGetOrSetDefinition() {
            return this.type == Type.GET || this.type == Type.SET;
        }

        boolean canCollapseUnannotatedChildNames() {
            if (this.type == Type.OTHER || this.isGetOrSetDefinition() || this.globalSets != 1 || this.localSets != 0 || this.deleteProps != 0) {
                return false;
            }
            Preconditions.checkNotNull((Object)this.declaration);
            if (this.declaration.getTwin() != null) {
                return false;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                return false;
            }
            if (this.usedHasOwnProperty) {
                return false;
            }
            if (this.declaredType) {
                return true;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                return false;
            }
            if (this.aliasingGets > 0) {
                return false;
            }
            return this.parent == null || this.parent.canCollapseUnannotatedChildNames();
        }

        boolean shouldKeepKeys() {
            return this.type == Type.OBJECTLIT && (this.aliasingGets > 0 || this.isCollapsingExplicitlyDenied());
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0 && this.localSetsWithNoCollapse == 0 && !this.isCollapsingExplicitlyDenied();
        }

        void setDeclaredType() {
            this.declaredType = true;
            Name ancestor = this.parent;
            while (ancestor != null) {
                ancestor.isDeclared = true;
                ancestor = ancestor.parent;
            }
        }

        boolean isDeclaredType() {
            return this.declaredType;
        }

        boolean isConstructor() {
            Node declNode = this.declaration.node;
            Node rvalueNode = NodeUtil.getRValueOfLValue(declNode);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            return rvalueNode != null && rvalueNode.isFunction() && jsdoc != null && jsdoc.isConstructor();
        }

        boolean isNamespaceObjectLit() {
            return this.isDeclared && this.type == Type.OBJECTLIT;
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        public String toString() {
            return this.getFullName() + " (" + (Object)((Object)this.type) + "): " + Joiner.on((String)", ").join((Object)("globalSets=" + this.globalSets), (Object)("localSets=" + this.localSets), new Object[]{"totalGets=" + this.totalGets, "aliasingGets=" + this.aliasingGets, "callGets=" + this.callGets});
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.docInfo;
        }

        private static JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node refParent = ref.node.getParent();
                if (refParent == null) {
                    return null;
                }
                switch (refParent.getToken()) {
                    case ASSIGN: 
                    case FUNCTION: 
                    case CLASS: {
                        return refParent.getJSDocInfo();
                    }
                    case VAR: 
                    case LET: 
                    case CONST: {
                        return ref.node == refParent.getFirstChild() ? refParent.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                    case OBJECTLIT: {
                        return ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        boolean isModuleExport() {
            return this.isModuleProp;
        }

        static enum Type {
            CLASS,
            OBJECTLIT,
            FUNCTION,
            GET,
            SET,
            OTHER;

        }
    }

    private class BuildGlobalNamespace
    extends NodeTraversal.AbstractPreOrderCallback {
        private BuildGlobalNamespace() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (GlobalNamespace.this.hasExternsRoot()) {
                if (n == GlobalNamespace.this.externsRoot) {
                    GlobalNamespace.this.externsScope = t.getScope();
                } else if (n.isScript()) {
                    GlobalNamespace.this.sourceKind = SourceKind.fromScriptNode(n);
                }
            }
            this.collect(t.getModule(), t.getScope(), n);
            return true;
        }

        public void collect(JSModule module, Scope scope, Node n) {
            String name;
            Node parent = n.getParent();
            boolean isSet = false;
            Name.Type type = Name.Type.OTHER;
            boolean isPropAssign = false;
            boolean shouldCreateProp = true;
            block0 : switch (n.getToken()) {
                case MEMBER_FUNCTION_DEF: 
                case STRING_KEY: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    name = null;
                    if (parent.isObjectLit()) {
                        name = this.getNameForObjLitKey(n);
                    } else if (parent.isClassMembers()) {
                        name = this.getNameForClassMembers(n);
                    }
                    if (name == null) {
                        return;
                    }
                    isSet = true;
                    switch (n.getToken()) {
                        case MEMBER_FUNCTION_DEF: {
                            type = this.getValueType(n.getFirstChild());
                            if (!n.getParent().isClassMembers() || n.isStaticMember()) break block0;
                            shouldCreateProp = false;
                            break block0;
                        }
                        case STRING_KEY: {
                            type = this.getValueType(n.getFirstChild());
                            break block0;
                        }
                        case GETTER_DEF: {
                            type = Name.Type.GET;
                            break block0;
                        }
                        case SETTER_DEF: {
                            type = Name.Type.SET;
                            break block0;
                        }
                        default: {
                            throw new IllegalStateException("unexpected:" + n);
                        }
                    }
                }
                case NAME: {
                    switch (parent.getToken()) {
                        case VAR: 
                        case LET: 
                        case CONST: {
                            isSet = true;
                            Node rvalue = n.getFirstChild();
                            type = rvalue == null ? Name.Type.OTHER : this.getValueType(rvalue);
                            break;
                        }
                        case ASSIGN: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = this.getValueType(n.getNext());
                            break;
                        }
                        case GETPROP: {
                            return;
                        }
                        case FUNCTION: {
                            Node grandparent = parent.getParent();
                            if (grandparent == null || NodeUtil.isFunctionExpression(parent)) {
                                return;
                            }
                            isSet = true;
                            type = Name.Type.FUNCTION;
                            break;
                        }
                        case CATCH: 
                        case INC: 
                        case DEC: {
                            isSet = true;
                            type = Name.Type.OTHER;
                            break;
                        }
                        case CLASS: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = Name.Type.CLASS;
                            break;
                        }
                        case ARRAY_PATTERN: {
                            isSet = true;
                            type = Name.Type.OTHER;
                            break;
                        }
                        default: {
                            if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                            isSet = true;
                            type = Name.Type.OTHER;
                        }
                    }
                    name = n.getString();
                    break;
                }
                case GETPROP: {
                    if (parent != null) {
                        switch (parent.getToken()) {
                            case ASSIGN: {
                                if (parent.getFirstChild() != n) break;
                                isSet = true;
                                type = this.getValueType(n.getNext());
                                isPropAssign = true;
                                break;
                            }
                            case INC: 
                            case DEC: {
                                isSet = true;
                                type = Name.Type.OTHER;
                                break;
                            }
                            case GETPROP: {
                                return;
                            }
                            default: {
                                if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                                isSet = true;
                                type = Name.Type.OTHER;
                            }
                        }
                    }
                    if (!n.isQualifiedName()) {
                        return;
                    }
                    name = n.getQualifiedName();
                    break;
                }
                case CALL: {
                    if (this.isObjectHasOwnPropertyCall(n)) {
                        String qname = n.getFirstFirstChild().getQualifiedName();
                        Name globalName = this.getOrCreateName(qname, true);
                        globalName.usedHasOwnProperty = true;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (!GlobalNamespace.this.isGlobalNameReference(name, scope)) {
                return;
            }
            if (isSet) {
                Scope hoistScope = (Scope)scope.getClosestHoistScope();
                if (hoistScope.isGlobal()) {
                    this.handleSetFromGlobal(module, scope, n, parent, name, isPropAssign, type, shouldCreateProp);
                } else {
                    this.handleSetFromLocal(module, scope, n, parent, name, shouldCreateProp);
                }
            } else {
                this.handleGet(module, scope, n, parent, name);
            }
        }

        String getNameForObjLitKey(Node n) {
            String key;
            String name;
            Node parent = n.getParent();
            Preconditions.checkState((boolean)parent.isObjectLit());
            Node grandparent = parent.getParent();
            if (grandparent == null) {
                return null;
            }
            Node greatGrandparent = grandparent.getParent();
            switch (grandparent.getToken()) {
                case NAME: {
                    if (greatGrandparent == null || !NodeUtil.isNameDeclaration(greatGrandparent)) {
                        return null;
                    }
                    name = grandparent.getString();
                    break;
                }
                case ASSIGN: {
                    Node lvalue = grandparent.getFirstChild();
                    name = lvalue.getQualifiedName();
                    break;
                }
                case STRING_KEY: {
                    if (greatGrandparent != null && greatGrandparent.isObjectLit()) {
                        name = this.getNameForObjLitKey(grandparent);
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (name != null && TokenStream.isJSIdentifier(key = n.getString())) {
                return name + '.' + key;
            }
            return null;
        }

        String getNameForClassMembers(Node n) {
            Node parent = n.getParent();
            Preconditions.checkState((boolean)parent.isClassMembers());
            String className = NodeUtil.getName(parent.getParent());
            return className == null ? null : className + '.' + n.getString();
        }

        Name.Type getValueType(Node n) {
            if (n == null) {
                return Name.Type.OTHER;
            }
            switch (n.getToken()) {
                case CLASS: {
                    return Name.Type.CLASS;
                }
                case OBJECTLIT: {
                    return Name.Type.OBJECTLIT;
                }
                case FUNCTION: {
                    return Name.Type.FUNCTION;
                }
                case OR: {
                    return this.getValueType(n.getLastChild());
                }
                case HOOK: {
                    Node second = n.getSecondChild();
                    Name.Type t = this.getValueType(second);
                    if (t != Name.Type.OTHER) {
                        return t;
                    }
                    Node third = second.getNext();
                    return this.getValueType(third);
                }
            }
            return Name.Type.OTHER;
        }

        void handleSetFromGlobal(JSModule module, Scope scope, Node n, Node parent, String name, boolean isPropAssign, Name.Type type, boolean shouldCreateProp) {
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, shouldCreateProp);
            nameObj.type = type;
            if (n.getBooleanProp((byte)97)) {
                nameObj.isModuleProp = true;
            }
            this.maybeRecordEs6Subclass(n, parent, nameObj);
            Ref set = new Ref(module, scope, n, nameObj, Ref.Type.SET_FROM_GLOBAL, GlobalNamespace.this.currentPreOrderIndex++);
            nameObj.addRef(set);
            if (this.isNestedAssign(parent)) {
                Ref get = new Ref(module, scope, n, nameObj, Ref.Type.ALIASING_GET, GlobalNamespace.this.currentPreOrderIndex++);
                nameObj.addRef(get);
                Ref.markTwins(set, get);
            } else if (this.isTypeDeclaration(n)) {
                nameObj.setDeclaredType();
            }
        }

        private void maybeRecordEs6Subclass(Node n, Node parent, Name subclassNameObj) {
            Node classNode;
            if (subclassNameObj.type != Name.Type.CLASS || parent == null) {
                return;
            }
            Node superclass = null;
            if (parent.isClass()) {
                superclass = parent.getSecondChild();
            } else if ((n.isName() || n.isGetProp()) && (classNode = NodeUtil.getAssignedValue(n)) != null && classNode.isClass()) {
                superclass = classNode.getSecondChild();
            }
            if (superclass == null || superclass.isEmpty() || !superclass.isName() && !superclass.isGetProp()) {
                return;
            }
            String superclassName = superclass.getQualifiedName();
            Name superclassNameObj = this.getOrCreateName(superclassName, true);
            if (superclassNameObj != null && superclassNameObj.type == Name.Type.CLASS) {
                superclassNameObj.addSubclass(subclassNameObj);
            }
        }

        private boolean isTypeDeclaration(Node n) {
            Node valueNode = NodeUtil.getRValueOfLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            return info != null && valueNode != null && (info.isConstructor() && valueNode.isFunction() || info.isInterface() && valueNode.isFunction() || info.hasEnumParameterType() && valueNode.isObjectLit());
        }

        void handleSetFromLocal(JSModule module, Scope scope, Node n, Node parent, String name, boolean shouldCreateProp) {
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, shouldCreateProp);
            Ref set = new Ref(module, scope, n, nameObj, Ref.Type.SET_FROM_LOCAL, GlobalNamespace.this.currentPreOrderIndex++);
            nameObj.addRef(set);
            if (n.getBooleanProp((byte)97)) {
                nameObj.isModuleProp = true;
            }
            if (this.isNestedAssign(parent)) {
                Ref get = new Ref(module, scope, n, nameObj, Ref.Type.ALIASING_GET, GlobalNamespace.this.currentPreOrderIndex++);
                nameObj.addRef(get);
                Ref.markTwins(set, get);
            }
        }

        void handleGet(JSModule module, Scope scope, Node n, Node parent, String name) {
            Ref.Type type;
            if (this.maybeHandlePrototypePrefix(module, scope, n, parent, name)) {
                return;
            }
            switch (parent.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case INSTANCEOF: 
                case TYPEOF: 
                case VOID: 
                case NOT: 
                case BITNOT: 
                case POS: 
                case NEG: {
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case CALL: {
                    if (n == parent.getFirstChild()) {
                        type = Ref.Type.CALL_GET;
                        break;
                    }
                    if (this.isClassDefiningCall(parent)) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case NEW: {
                    type = n == parent.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                    break;
                }
                case OR: 
                case AND: {
                    type = this.determineGetTypeForHookOrBooleanExpr(module, scope, parent, name);
                    break;
                }
                case HOOK: {
                    if (n != parent.getFirstChild()) {
                        type = this.determineGetTypeForHookOrBooleanExpr(module, scope, parent, name);
                        break;
                    }
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case DELPROP: {
                    type = Ref.Type.DELETE_PROP;
                    break;
                }
                case CLASS: {
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                default: {
                    type = Ref.Type.ALIASING_GET;
                }
            }
            this.handleGet(module, scope, n, parent, name, type, true);
        }

        void handleGet(JSModule module, Scope scope, Node n, Node parent, String name, Ref.Type type, boolean shouldCreateProp) {
            Name nameObj = this.getOrCreateName(name, shouldCreateProp);
            nameObj.addRef(new Ref(module, scope, n, nameObj, type, GlobalNamespace.this.currentPreOrderIndex++));
        }

        private boolean isClassDefiningCall(Node callNode) {
            CodingConvention convention = GlobalNamespace.this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(callNode);
            if (classes != null) {
                return true;
            }
            String className = convention.getSingletonGetterClassName(callNode);
            return className != null;
        }

        private boolean isObjectHasOwnPropertyCall(Node callNode) {
            Preconditions.checkArgument((boolean)callNode.isCall(), (Object)callNode);
            if (!callNode.hasTwoChildren()) {
                return false;
            }
            Node fn = callNode.getFirstChild();
            if (!fn.isGetProp()) {
                return false;
            }
            Node callee = fn.getFirstChild();
            Node method = fn.getSecondChild();
            return method.isString() && "hasOwnProperty".equals(method.getString()) && callee.isQualifiedName();
        }

        Ref.Type determineGetTypeForHookOrBooleanExpr(JSModule module, Scope scope, Node parent, String name) {
            Node prev = parent;
            for (Node anc : parent.getAncestors()) {
                switch (anc.getToken()) {
                    case VAR: 
                    case LET: 
                    case CONST: 
                    case EXPR_RESULT: 
                    case IF: 
                    case INSTANCEOF: 
                    case TYPEOF: 
                    case VOID: 
                    case NOT: 
                    case BITNOT: 
                    case POS: 
                    case NEG: 
                    case WHILE: 
                    case FOR: 
                    case FOR_IN: {
                        return Ref.Type.DIRECT_GET;
                    }
                    case HOOK: {
                        if (anc.getFirstChild() != prev) break;
                        return Ref.Type.DIRECT_GET;
                    }
                    case ASSIGN: {
                        if (anc.getFirstChild().matchesQualifiedName(name)) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case NAME: {
                        if (name.equals(anc.getString())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case CALL: {
                        if (anc.getFirstChild() == prev) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case DELPROP: {
                        return Ref.Type.DELETE_PROP;
                    }
                }
                prev = anc;
            }
            return Ref.Type.ALIASING_GET;
        }

        boolean maybeHandlePrototypePrefix(JSModule module, Scope scope, Node n, Node parent, String name) {
            int i;
            String prefix;
            int numLevelsToRemove;
            if (name.endsWith(".prototype")) {
                numLevelsToRemove = 1;
                prefix = name.substring(0, name.length() - 10);
            } else {
                i = name.indexOf(".prototype.");
                if (i == -1) {
                    return false;
                }
                prefix = name.substring(0, i);
                numLevelsToRemove = 2;
                i = name.indexOf(46, i + 11);
                while (i >= 0) {
                    ++numLevelsToRemove;
                    i = name.indexOf(46, i + 1);
                }
            }
            if (parent != null && NodeUtil.isObjectLitKey(n)) {
                return true;
            }
            for (i = 0; i < numLevelsToRemove; ++i) {
                parent = n;
                n = n.getFirstChild();
            }
            this.handleGet(module, scope, n, parent, prefix, Ref.Type.PROTOTYPE_GET, true);
            return true;
        }

        boolean isNestedAssign(Node parent) {
            return parent.isAssign() && !parent.getParent().isExprResult();
        }

        Name getOrCreateName(String name, boolean shouldCreateProp) {
            Name node = (Name)GlobalNamespace.this.nameMap.get(name);
            if (node == null) {
                int i = name.lastIndexOf(46);
                if (i >= 0) {
                    String parentName = name.substring(0, i);
                    Name parent = this.getOrCreateName(parentName, true);
                    node = parent.addProperty(name.substring(i + 1), GlobalNamespace.this.sourceKind, shouldCreateProp);
                } else {
                    node = new Name(name, null, GlobalNamespace.this.sourceKind);
                    GlobalNamespace.this.globalNames.add(node);
                }
                GlobalNamespace.this.nameMap.put(name, node);
            }
            return node;
        }
    }

    static class AstChange {
        final JSModule module;
        final Scope scope;
        final Node node;

        AstChange(JSModule module, Scope scope, Node node) {
            this.module = module;
            this.scope = scope;
            this.node = node;
        }

        public boolean equals(Object obj) {
            Preconditions.checkState((boolean)(obj instanceof AstChange));
            AstChange other = (AstChange)obj;
            return Objects.equals(this.module, other.module) && Objects.equals(this.scope, other.scope) && Objects.equals(this.node, other.node);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.scope, this.node);
        }
    }

    static enum SourceKind {
        EXTERN,
        TYPE_SUMMARY,
        CODE;


        static SourceKind fromScriptNode(Node n) {
            if (!n.isFromExterns()) {
                return CODE;
            }
            if (NodeUtil.isFromTypeSummary(n)) {
                return TYPE_SUMMARY;
            }
            return EXTERN;
        }
    }
}

