/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

@GwtIncompatible(value="JsMessage.Builder")
public final class JsMessageExtractor {
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;
    private final CompilerOptions options;
    private final boolean extractExternalMessages;

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style) {
        this(idGenerator, style, new CompilerOptions(), false);
    }

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style, CompilerOptions options, boolean extractExternalMessages) {
        this.idGenerator = idGenerator;
        this.style = style;
        this.options = options;
        this.extractExternalMessages = extractExternalMessages;
    }

    public Collection<JsMessage> extractMessages(SourceFile ... inputs) throws IOException {
        return this.extractMessages((Iterable)ImmutableList.copyOf((Object[])inputs));
    }

    public <T extends SourceFile> Collection<JsMessage> extractMessages(Iterable<T> inputs) {
        JSError[] errors;
        final Compiler compiler = new Compiler();
        compiler.init(ImmutableList.of(), ImmutableList.copyOf(inputs), this.options);
        compiler.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                compiler.parseInputs();
                return null;
            }
        });
        ExtractMessagesVisitor extractCompilerPass = new ExtractMessagesVisitor(compiler);
        if (compiler.getErrors().length == 0) {
            extractCompilerPass.process(null, compiler.getRoot());
        }
        if ((errors = compiler.getErrors()).length > 0) {
            StringBuilder msg = new StringBuilder("JSCompiler errors\n");
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(compiler);
            for (JSError e : errors) {
                msg.append(formatter.formatError(e));
            }
            throw new RuntimeException(msg.toString());
        }
        return extractCompilerPass.getMessages();
    }

    private class ExtractMessagesVisitor
    extends JsMessageVisitor {
        private final List<JsMessage> messages;

        private ExtractMessagesVisitor(AbstractCompiler compiler) {
            super(compiler, true, JsMessageExtractor.this.style, JsMessageExtractor.this.idGenerator);
            this.messages = new ArrayList<JsMessage>();
        }

        @Override
        protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
            if (JsMessageExtractor.this.extractExternalMessages || !message.isExternal()) {
                this.messages.add(message);
            }
        }

        public Collection<JsMessage> getMessages() {
            return this.messages;
        }
    }
}

