/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.TernaryValue;
import javax.annotation.Nullable;

class PeepholeRemoveDeadCode
extends AbstractPeepholeOptimization {
    private static final Predicate<Node> IS_UNNAMED_BREAK_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return node.isBreak() && !node.hasChildren();
        }
    };
    private static final Predicate<Node> IS_UNNAMED_CONTINUE_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return node.isContinue() && !node.hasChildren();
        }
    };
    private static final Predicate<Node> CAN_CONTAIN_BREAK_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return !IR.mayBeExpression(node) && !NodeUtil.isLoopStructure(node) && !node.isSwitch();
        }
    };
    private static final Predicate<Node> CAN_CONTAIN_CONTINUE_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return !IR.mayBeExpression(node) && !NodeUtil.isLoopStructure(node);
        }
    };
    static final Predicate<Node> MATCH_UNNAMED_BREAK = new MatchUnnamedBreak();

    PeepholeRemoveDeadCode() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getToken()) {
            case ASSIGN: {
                return this.tryFoldAssignment(subtree);
            }
            case COMMA: {
                return this.tryFoldComma(subtree);
            }
            case SCRIPT: 
            case BLOCK: {
                return this.tryOptimizeBlock(subtree);
            }
            case EXPR_RESULT: {
                subtree = this.tryFoldExpr(subtree);
                return subtree;
            }
            case HOOK: {
                return this.tryFoldHook(subtree);
            }
            case SWITCH: {
                return this.tryOptimizeSwitch(subtree);
            }
            case IF: {
                return this.tryFoldIf(subtree);
            }
            case WHILE: {
                return this.tryFoldWhile(subtree);
            }
            case FOR: {
                Node condition = NodeUtil.getConditionExpression(subtree);
                if (condition != null) {
                    this.tryFoldForCondition(condition);
                }
                return this.tryFoldFor(subtree);
            }
            case DO: {
                Node foldedDo = this.tryFoldDoAway(subtree);
                if (foldedDo.isDo()) {
                    return this.tryFoldEmptyDo(foldedDo);
                }
                return foldedDo;
            }
            case TRY: {
                return this.tryFoldTry(subtree);
            }
            case LABEL: {
                return this.tryFoldLabel(subtree);
            }
        }
        return subtree;
    }

    private Node tryFoldLabel(Node n) {
        String labelName = n.getFirstChild().getString();
        Node stmt = n.getLastChild();
        if (stmt.isEmpty() || stmt.isBlock() && !stmt.hasChildren()) {
            this.compiler.reportChangeToEnclosingScope(n);
            n.detach();
            return null;
        }
        Node child = PeepholeRemoveDeadCode.getOnlyInterestingChild(stmt);
        if (child != null) {
            stmt = child;
        }
        if (stmt.isBreak() && stmt.getFirstChild().getString().equals(labelName)) {
            this.compiler.reportChangeToEnclosingScope(n);
            n.detach();
            return null;
        }
        return n;
    }

    @Nullable
    private static Node getOnlyInterestingChild(Node block) {
        if (!block.isBlock()) {
            return null;
        }
        if (block.hasOneChild()) {
            return block.getOnlyChild();
        }
        Node ret = null;
        for (Node child : block.children()) {
            if (child.isSyntheticBlock() && !child.hasChildren()) continue;
            if (ret != null) {
                return null;
            }
            ret = child;
        }
        return ret;
    }

    private Node tryFoldTry(Node n) {
        Preconditions.checkState((boolean)n.isTry(), (Object)n);
        Node body = n.getFirstChild();
        Node catchBlock = body.getNext();
        Node finallyBlock = catchBlock.getNext();
        if (!(catchBlock.hasChildren() || finallyBlock != null && finallyBlock.hasChildren())) {
            n.removeChild(body);
            n.replaceWith(body);
            this.compiler.reportChangeToEnclosingScope(body);
            return body;
        }
        if (!body.hasChildren()) {
            NodeUtil.redeclareVarsInsideBranch(catchBlock);
            this.compiler.reportChangeToEnclosingScope(n);
            if (finallyBlock != null) {
                n.removeChild(finallyBlock);
                n.replaceWith(finallyBlock);
            } else {
                n.detach();
            }
            return finallyBlock;
        }
        return n;
    }

    private Node tryFoldAssignment(Node subtree) {
        Preconditions.checkState((boolean)subtree.isAssign());
        Node left = subtree.getFirstChild();
        Node right = subtree.getLastChild();
        if (left.isName() && right.isName() && left.getString().equals(right.getString())) {
            subtree.replaceWith(right.detach());
            this.compiler.reportChangeToEnclosingScope(right);
            return right;
        }
        return subtree;
    }

    private Node tryFoldExpr(Node subtree) {
        Node result = this.trySimplifyUnusedResult(subtree.getFirstChild());
        if (result == null) {
            Node parent = subtree.getParent();
            if (parent.isLabel()) {
                Node replacement = IR.block().srcref(subtree);
                parent.replaceChild(subtree, replacement);
                subtree = replacement;
            } else {
                subtree.detach();
                subtree = null;
            }
        }
        return subtree;
    }

    private Node trySimplifyUnusedResult(Node n) {
        return this.trySimplifyUnusedResult(n, true);
    }

    private Node trySimplifyUnusedResult(Node n, boolean removeUnused) {
        Node result = n;
        switch (n.getToken()) {
            case HOOK: {
                Node trueNode = this.trySimplifyUnusedResult(n.getSecondChild());
                Node falseNode = this.trySimplifyUnusedResult(n.getLastChild());
                if (trueNode == null && falseNode != null) {
                    n.setToken(Token.OR);
                    Preconditions.checkState((boolean)n.hasTwoChildren(), (Object)n);
                    break;
                }
                if (trueNode != null && falseNode == null) {
                    n.setToken(Token.AND);
                    Preconditions.checkState((boolean)n.hasTwoChildren(), (Object)n);
                    break;
                }
                if (trueNode == null && falseNode == null) {
                    result = this.trySimplifyUnusedResult(n.getFirstChild());
                    break;
                }
                result = n;
                break;
            }
            case AND: 
            case OR: {
                Node conditionalResultNode = this.trySimplifyUnusedResult(n.getLastChild());
                if (conditionalResultNode != null) break;
                Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                result = this.trySimplifyUnusedResult(n.getFirstChild());
                break;
            }
            case FUNCTION: {
                result = null;
                break;
            }
            case COMMA: {
                Node left = this.trySimplifyUnusedResult(n.getFirstChild());
                Node right = this.trySimplifyUnusedResult(n.getLastChild());
                if (left == null && right == null) {
                    result = null;
                    break;
                }
                if (left == null) {
                    result = right;
                    break;
                }
                if (right == null) {
                    result = left;
                    break;
                }
                result = n;
                break;
            }
            default: {
                if (this.nodeTypeMayHaveSideEffects(n)) break;
                Node resultList = null;
                Node c = n.getFirstChild();
                while (c != null) {
                    Node next = c.getNext();
                    if ((c = this.trySimplifyUnusedResult(c)) != null) {
                        c.detach();
                        resultList = resultList == null ? c : IR.comma(resultList, c).srcref(c);
                    }
                    c = next;
                }
                result = resultList;
            }
        }
        if (n != result) {
            Node parent = n.getParent();
            if (result == null) {
                if (removeUnused) {
                    parent.removeChild(n);
                    NodeUtil.markFunctionsDeleted(n, this.compiler);
                } else {
                    result = IR.empty().srcref(n);
                    parent.replaceChild(n, result);
                }
            } else {
                if (result.getParent() != null) {
                    result.detach();
                }
                n.replaceWith(result);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        return result;
    }

    private void removeIfUnnamedBreak(Node maybeBreak) {
        if (maybeBreak != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            this.compiler.reportChangeToEnclosingScope(maybeBreak);
            maybeBreak.detach();
        }
    }

    private Node tryRemoveSwitchWithSingleCase(Node n, boolean shouldHoistCondition) {
        Node caseBlock = n.getLastChild().getLastChild();
        this.removeIfUnnamedBreak(caseBlock.getLastChild());
        if (NodeUtil.has(caseBlock, MATCH_UNNAMED_BREAK, NodeUtil.MATCH_NOT_FUNCTION)) {
            return n;
        }
        if (shouldHoistCondition) {
            Node switchBlock = caseBlock.getGrandparent();
            switchBlock.getParent().addChildAfter(IR.exprResult(n.removeFirstChild()).srcref(n), switchBlock.getPrevious());
        }
        n.replaceWith(caseBlock.detach());
        this.compiler.reportChangeToEnclosingScope(caseBlock);
        return caseBlock;
    }

    private Node tryRemoveSwitch(Node n) {
        if (n.hasOneChild()) {
            Node condition = n.removeFirstChild();
            Node replacement = IR.exprResult(condition).srcref(n);
            n.replaceWith(replacement);
            this.compiler.reportChangeToEnclosingScope(replacement);
            return replacement;
        }
        if (n.hasTwoChildren() && n.getLastChild().isDefaultCase()) {
            if (n.getFirstChild().isCall()) {
                return this.tryRemoveSwitchWithSingleCase(n, true);
            }
            return this.tryRemoveSwitchWithSingleCase(n, false);
        }
        return n;
    }

    private Node tryOptimizeSwitch(Node n) {
        Preconditions.checkState((boolean)n.isSwitch(), (Object)n);
        Node defaultCase = this.tryOptimizeDefaultCase(n);
        if (defaultCase == null || n.getLastChild().isDefaultCase()) {
            Node cond = n.getFirstChild();
            Node prev = null;
            Node next = null;
            Node cur = cond.getNext();
            while (cur != null) {
                next = cur.getNext();
                if (!this.mayHaveSideEffects(cur.getFirstChild()) && this.isUselessCase(cur, prev, defaultCase)) {
                    this.removeCase(n, cur);
                } else {
                    prev = cur;
                }
                cur = next;
            }
            if (NodeUtil.isLiteralValue(cond, false)) {
                TernaryValue caseMatches = TernaryValue.TRUE;
                cur = cond.getNext();
                while (cur != null) {
                    next = cur.getNext();
                    Node caseLabel = cur.getFirstChild();
                    caseMatches = PeepholeFoldConstants.evaluateComparison(Token.SHEQ, cond, caseLabel);
                    if (caseMatches == TernaryValue.TRUE || caseMatches == TernaryValue.UNKNOWN) break;
                    this.removeCase(n, cur);
                    cur = next;
                }
                if (cur != null && caseMatches == TernaryValue.TRUE) {
                    Node matchingCase = cur;
                    Node matchingCaseBlock = matchingCase.getLastChild();
                    while (cur != null) {
                        Node block = cur.getLastChild();
                        Node lastStm = block.getLastChild();
                        boolean isLastStmRemovableBreak = false;
                        if (lastStm != null && PeepholeRemoveDeadCode.isExit(lastStm)) {
                            this.removeIfUnnamedBreak(lastStm);
                            isLastStmRemovableBreak = true;
                        }
                        next = cur.getNext();
                        if (cur != matchingCase) {
                            while (block.hasChildren()) {
                                matchingCaseBlock.addChildToBack(block.getFirstChild().detach());
                            }
                            this.compiler.reportChangeToEnclosingScope(cur);
                            cur.detach();
                        }
                        cur = next;
                        if (!isLastStmRemovableBreak) continue;
                        break;
                    }
                    while (cur != null) {
                        next = cur.getNext();
                        this.removeCase(n, cur);
                        cur = next;
                    }
                    cur = cond.getNext();
                    if (cur != null && cur.getNext() == null) {
                        return this.tryRemoveSwitchWithSingleCase(n, false);
                    }
                }
            }
        }
        return this.tryRemoveSwitch(n);
    }

    private Node tryOptimizeDefaultCase(Node n) {
        Preconditions.checkState((boolean)n.isSwitch(), (Object)n);
        Node lastNonRemovable = n.getFirstChild();
        for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
            if (c.isDefaultCase()) {
                Node prevCase;
                Node caseToRemove = lastNonRemovable.getNext();
                while (caseToRemove != c) {
                    Node next = caseToRemove.getNext();
                    this.removeCase(n, caseToRemove);
                    caseToRemove = next;
                }
                Node node = prevCase = lastNonRemovable == n.getFirstChild() ? null : lastNonRemovable;
                if (this.isUselessCase(c, prevCase, c)) {
                    this.removeCase(n, c);
                    return null;
                }
                return c;
            }
            Preconditions.checkState((boolean)c.isCase());
            if (!c.getLastChild().hasChildren() && !this.mayHaveSideEffects(c.getFirstChild())) continue;
            lastNonRemovable = c;
        }
        return null;
    }

    private void removeCase(Node switchNode, Node caseNode) {
        NodeUtil.redeclareVarsInsideBranch(caseNode);
        switchNode.removeChild(caseNode);
        this.compiler.reportChangeToEnclosingScope(switchNode);
    }

    private boolean isUselessCase(Node caseNode, @Nullable Node previousCase, @Nullable Node defaultCase) {
        Node previousBlock;
        Preconditions.checkState((previousCase == null || previousCase.getNext() == caseNode ? 1 : 0) != 0);
        Node switchNode = caseNode.getParent();
        if (!(switchNode.getLastChild() == caseNode || previousCase == null || (previousBlock = previousCase.getLastChild()).hasChildren() && PeepholeRemoveDeadCode.isExit(previousBlock.getLastChild()))) {
            return false;
        }
        for (Node executingCase = caseNode; executingCase != null; executingCase = executingCase.getNext()) {
            Preconditions.checkState((executingCase.isDefaultCase() || executingCase.isCase() ? 1 : 0) != 0);
            Preconditions.checkState((caseNode == executingCase || !executingCase.isDefaultCase() ? 1 : 0) != 0);
            Node block = executingCase.getLastChild();
            Preconditions.checkState((boolean)block.isBlock());
            if (!block.hasChildren()) continue;
            block5: for (Node blockChild : block.children()) {
                switch (blockChild.getToken()) {
                    case BREAK: {
                        return !blockChild.hasChildren() && (defaultCase == null || defaultCase == executingCase);
                    }
                    case VAR: {
                        if (blockChild.hasOneChild() && blockChild.getFirstFirstChild() == null) continue block5;
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isExit(Node n) {
        switch (n.getToken()) {
            case BREAK: 
            case CONTINUE: 
            case RETURN: 
            case THROW: {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldComma(Node n) {
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = left.getNext();
        if ((left = this.trySimplifyUnusedResult(left)) == null || !this.mayHaveSideEffects(left)) {
            n.removeChild(right);
            parent.replaceChild(n, right);
            this.compiler.reportChangeToEnclosingScope(parent);
            return right;
        }
        return n;
    }

    Node tryOptimizeBlock(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            if (!PeepholeRemoveDeadCode.isUnremovableNode(c) && !this.mayHaveSideEffects(c)) {
                n.removeChild(c);
                this.compiler.reportChangeToEnclosingScope(n);
                NodeUtil.markFunctionsDeleted(c, this.compiler);
            } else {
                this.tryOptimizeConditionalAfterAssign(c);
            }
            c = next;
        }
        if (n.isSyntheticBlock() || n.isScript() || n.getParent() == null) {
            return n;
        }
        Node parent = n.getParent();
        if (NodeUtil.tryMergeBlock(n, false)) {
            this.compiler.reportChangeToEnclosingScope(parent);
            return null;
        }
        return n;
    }

    private static boolean isUnremovableNode(Node n) {
        return n.isBlock() && n.isSyntheticBlock() || n.isScript();
    }

    private void tryOptimizeConditionalAfterAssign(Node n) {
        Node next = n.getNext();
        if (PeepholeRemoveDeadCode.isSimpleAssignment(n) && this.isConditionalStatement(next)) {
            Node rhsAssign;
            TernaryValue value;
            Node lhsAssign = this.getSimpleAssignmentName(n);
            Node condition = this.getConditionalStatementCondition(next);
            if (lhsAssign.isName() && condition.isName() && lhsAssign.getString().equals(condition.getString()) && (value = NodeUtil.getImpureBooleanValue(rhsAssign = this.getSimpleAssignmentValue(n))) != TernaryValue.UNKNOWN) {
                Node replacementConditionNode = NodeUtil.booleanNode(value.toBoolean(true));
                condition.replaceWith(replacementConditionNode);
                this.compiler.reportChangeToEnclosingScope(replacementConditionNode);
            }
        }
    }

    private static boolean isSimpleAssignment(Node n) {
        if (NodeUtil.isExprAssign(n) && n.getFirstFirstChild().isName()) {
            return true;
        }
        return NodeUtil.isNameDeclaration(n) && n.hasOneChild() && n.getFirstFirstChild() != null;
    }

    private Node getSimpleAssignmentName(Node n) {
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isSimpleAssignment(n));
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstFirstChild();
        }
        return n.getFirstChild();
    }

    private Node getSimpleAssignmentValue(Node n) {
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isSimpleAssignment(n));
        return n.getFirstChild().getLastChild();
    }

    private boolean isConditionalStatement(Node n) {
        return n != null && (n.isIf() || PeepholeRemoveDeadCode.isExprConditional(n));
    }

    private static boolean isExprConditional(Node n) {
        if (n.isExprResult()) {
            switch (n.getFirstChild().getToken()) {
                case HOOK: 
                case AND: 
                case OR: {
                    return true;
                }
            }
        }
        return false;
    }

    private Node getConditionalStatementCondition(Node n) {
        if (n.isIf()) {
            return NodeUtil.getConditionExpression(n);
        }
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isExprConditional(n));
        return n.getFirstFirstChild();
    }

    private Node tryFoldIf(Node n) {
        Preconditions.checkState((boolean)n.isIf(), (Object)n);
        Node parent = n.getParent();
        Preconditions.checkNotNull((Object)parent);
        Token type = n.getToken();
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        if (elseBody != null && !this.mayHaveSideEffects(elseBody)) {
            n.removeChild(elseBody);
            this.compiler.reportChangeToEnclosingScope(n);
            elseBody = null;
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody != null) {
            n.removeChild(elseBody);
            n.replaceChild(thenBody, elseBody);
            Node notCond = new Node(Token.NOT);
            n.replaceChild(cond, notCond);
            this.compiler.reportChangeToEnclosingScope(n);
            notCond.addChildToFront(cond);
            cond = notCond;
            thenBody = cond.getNext();
            elseBody = null;
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody == null) {
            if (this.mayHaveSideEffects(cond)) {
                n.removeChild(cond);
                Node replacement = NodeUtil.newExpr(cond);
                parent.replaceChild(n, replacement);
                this.compiler.reportChangeToEnclosingScope(parent);
                return replacement;
            }
            NodeUtil.removeChild(parent, n);
            this.compiler.reportChangeToEnclosingScope(parent);
            return null;
        }
        TernaryValue condValue = NodeUtil.getImpureBooleanValue(cond);
        if (condValue == TernaryValue.UNKNOWN) {
            return n;
        }
        if (this.mayHaveSideEffects(cond)) {
            boolean newConditionValue;
            boolean bl = newConditionValue = condValue == TernaryValue.TRUE;
            if (!newConditionValue && elseBody == null) {
                elseBody = IR.block().srcref(n);
                n.addChildToBack(elseBody);
            }
            Node newCond = NodeUtil.booleanNode(newConditionValue);
            n.replaceChild(cond, newCond);
            Node branchToKeep = newConditionValue ? thenBody : elseBody;
            branchToKeep.addChildToFront(IR.exprResult(cond).srcref(cond));
            this.compiler.reportChangeToEnclosingScope(branchToKeep);
            cond = newCond;
        }
        boolean condTrue = condValue.toBoolean(true);
        if (n.hasTwoChildren()) {
            Preconditions.checkState((type == Token.IF ? 1 : 0) != 0);
            if (condTrue) {
                Node thenStmt = n.getSecondChild();
                n.removeChild(thenStmt);
                parent.replaceChild(n, thenStmt);
                this.compiler.reportChangeToEnclosingScope(thenStmt);
                return thenStmt;
            }
            NodeUtil.redeclareVarsInsideBranch(n);
            NodeUtil.removeChild(parent, n);
            this.compiler.reportChangeToEnclosingScope(parent);
            NodeUtil.markFunctionsDeleted(n, this.compiler);
            return null;
        }
        Node trueBranch = n.getSecondChild();
        Node falseBranch = trueBranch.getNext();
        Node branchToKeep = condTrue ? trueBranch : falseBranch;
        Node branchToRemove = condTrue ? falseBranch : trueBranch;
        NodeUtil.redeclareVarsInsideBranch(branchToRemove);
        n.removeChild(branchToKeep);
        parent.replaceChild(n, branchToKeep);
        this.compiler.reportChangeToEnclosingScope(branchToKeep);
        NodeUtil.markFunctionsDeleted(n, this.compiler);
        return branchToKeep;
    }

    private Node tryFoldHook(Node n) {
        Node replacement;
        Node branchToRemove;
        Node branchToKeep;
        Preconditions.checkState((boolean)n.isHook(), (Object)n);
        Node parent = n.getParent();
        Preconditions.checkNotNull((Object)parent);
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        TernaryValue condValue = NodeUtil.getImpureBooleanValue(cond);
        if (condValue == TernaryValue.UNKNOWN && !this.areNodesEqualForInlining(thenBody, elseBody)) {
            return n;
        }
        if (condValue.toBoolean(true)) {
            branchToKeep = thenBody;
            branchToRemove = elseBody;
        } else {
            branchToKeep = elseBody;
            branchToRemove = thenBody;
        }
        boolean condHasSideEffects = this.mayHaveSideEffects(cond);
        n.detachChildren();
        if (condHasSideEffects) {
            replacement = IR.comma(cond, branchToKeep).srcref(n);
        } else {
            replacement = branchToKeep;
            NodeUtil.markFunctionsDeleted(cond, this.compiler);
        }
        parent.replaceChild(n, replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
        NodeUtil.markFunctionsDeleted(branchToRemove, this.compiler);
        return replacement;
    }

    Node tryFoldWhile(Node n) {
        Preconditions.checkArgument((boolean)n.isWhile());
        Node cond = NodeUtil.getConditionExpression(n);
        if (NodeUtil.getPureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        NodeUtil.redeclareVarsInsideBranch(n);
        this.compiler.reportChangeToEnclosingScope(n.getParent());
        NodeUtil.removeChild(n.getParent(), n);
        return null;
    }

    Node tryFoldFor(Node n) {
        Preconditions.checkArgument((boolean)n.isVanillaFor());
        Node init = n.getFirstChild();
        Node cond = init.getNext();
        Node increment = cond.getNext();
        if (!init.isEmpty() && !NodeUtil.isNameDeclaration(init)) {
            init = this.trySimplifyUnusedResult(init, false);
        }
        if (!increment.isEmpty()) {
            increment = this.trySimplifyUnusedResult(increment, false);
        }
        if (!n.getFirstChild().isEmpty()) {
            return n;
        }
        if (NodeUtil.getImpureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        Node parent = n.getParent();
        NodeUtil.redeclareVarsInsideBranch(n);
        if (!this.mayHaveSideEffects(cond)) {
            NodeUtil.removeChild(parent, n);
        } else {
            Node statement = IR.exprResult(cond.detach()).useSourceInfoIfMissingFrom(cond);
            if (parent.isLabel()) {
                Node block = IR.block();
                block.useSourceInfoIfMissingFrom(statement);
                block.addChildToFront(statement);
                statement = block;
            }
            parent.replaceChild(n, statement);
        }
        this.compiler.reportChangeToEnclosingScope(parent);
        return null;
    }

    Node tryFoldDoAway(Node n) {
        Preconditions.checkArgument((boolean)n.isDo());
        Node cond = NodeUtil.getConditionExpression(n);
        if (NodeUtil.getImpureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        Node block = NodeUtil.getLoopCodeBlock(n);
        if (n.getParent().isLabel() || PeepholeRemoveDeadCode.hasUnnamedBreakOrContinue(block)) {
            return n;
        }
        Node parent = n.getParent();
        n.replaceWith(block.detach());
        if (this.mayHaveSideEffects(cond)) {
            Node condStatement = IR.exprResult(cond.detach()).srcref(cond);
            parent.addChildAfter(condStatement, block);
        }
        this.compiler.reportChangeToEnclosingScope(parent);
        return block;
    }

    Node tryFoldEmptyDo(Node n) {
        Preconditions.checkArgument((boolean)n.isDo());
        Node body = NodeUtil.getLoopCodeBlock(n);
        if (body.isBlock() && !body.hasChildren()) {
            Node cond = NodeUtil.getConditionExpression(n);
            Node forNode = IR.forNode(IR.empty().srcref(n), cond.detach(), IR.empty().srcref(n), body.detach());
            n.replaceWith(forNode);
            this.compiler.reportChangeToEnclosingScope(forNode);
            return forNode;
        }
        return n;
    }

    static boolean hasUnnamedBreakOrContinue(Node n) {
        return NodeUtil.has(n, IS_UNNAMED_BREAK_PREDICATE, CAN_CONTAIN_BREAK_PREDICATE) || NodeUtil.has(n, IS_UNNAMED_CONTINUE_PREDICATE, CAN_CONTAIN_CONTINUE_PREDICATE);
    }

    private void tryFoldForCondition(Node forCondition) {
        if (NodeUtil.getPureBooleanValue(forCondition) == TernaryValue.TRUE) {
            this.compiler.reportChangeToEnclosingScope(forCondition);
            forCondition.replaceWith(IR.empty());
        }
    }

    private static class MatchUnnamedBreak
    implements Predicate<Node> {
        private MatchUnnamedBreak() {
        }

        public boolean apply(Node n) {
            return n.isBreak() && !n.hasChildren();
        }
    }
}

